#include <gl/glut.h>
#include <math.h>

void draw_circ(int cx, int cy, float sweep_angle, float angle, float radius) {

  const int n = 1000;
  float ang = sweep_angle * 3.14159265/180;
  float ang_inc = angle * 3.14159265/(180*n);
  int k;
  glBegin(GL_LINE_STRIP);
  for(k=1; k <= n; k++, ang+=ang_inc) 
    glVertex2f((GLfloat)cx+radius*cos(ang), (GLfloat)cy+radius*sin(ang));
  glEnd();

}

void init(void) {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(-25.0, 25.0, -25.0, 25.0);
  glViewport(0, 0, 500, 500);
}

void display(void) {

int m;
int a=5;

  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);

for(m=0; m<10; m++) {
     draw_circ(0, a * sqrt(m*m-1), 0.0, 360.0, a*m); 
     draw_circ(0, -a*sqrt(m*m-1), 0.0, 360.0, a*m);
}
glFlush();

for(m=0;m<10;m++) {
     draw_circ(a*m, 0, 0.0, 360.0, a * sqrt(m*m-1) );
     draw_circ(-a*m, 0, 0.0, 360.0, a*sqrt(m*m-1) );
}
glFlush();

}

int main(int argc, char **argv) {

  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Old French Ogive");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  init();
  glutDisplayFunc(display);
  glutMainLoop();

  return 0;
}
