#include <gl/glut.h>
#include <math.h>


void init(void) {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(-25.0, 25.0, -25.0, 25.0);
  glViewport(0, 0, 500, 500);
}


void draw_ellipse(float a, float b) {

	float x;
glBegin(GL_POINTS);
for( x=-a; x<=a; x+=0.01) {
	glVertex2f(x, sqrt((b*b)*(1-((x*x)/(a*a)))));
	glVertex2f(x, -sqrt((b*b)*(1-((x*x)/(a*a)))));
}
glEnd();
}

void draw_spiral(float r) {

float x;
int i, z=1;	
glBegin(GL_POINTS);
for(i=1; i<5; i++){
	r += r*i;
	for( x=-r; x<=r; x+=0.01) {
		glVertex2f(x, sqrt((r*r)*(1-((x*x)/(r*r)))));
		glVertex2f(x, z*sqrt((r*r)*(1-((x*x)/(r*r)))));
	}
z=-z;
}
glEnd();

}

void display(void) {

  float radius=5.0;

  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);

	draw_spiral(radius);
	glFlush();

glBegin(GL_LINES);
	glVertex2f(-25.0, 0.0);
	glVertex2f(25.0, 0.0);
	glVertex2f(0.0, -25.0);
	glVertex2f(0.0, 25.0);
glEnd();
glFlush();
}

int main(int argc, char **argv) {

  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("A Logarithmic Spiral");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  init();
  glutDisplayFunc(display);
  glutMainLoop();

  return 0;
}
