#include <gl/glut.h>
#include <cmath>
#include <cstdlib>

void draw_circ(int cx, int cy, float sweep_angle, float angle, float radius) {

  const int n = 500;
  float ang = sweep_angle * 3.14159265/180;
  float ang_inc = angle * 3.14159265/(180*n);
  int k;
  glBegin(GL_POINTS);
  for(k=1; k <= n; k++, ang+=ang_inc) 
    glVertex2f((GLfloat)cx+radius*cos(ang), (GLfloat)cy+radius*sin(ang));
  glEnd();

}

void draw_rect(int x, int y, int width, int height) {

  glBegin(GL_LINE_STRIP);
  glVertex2i(x, y);
  glVertex2i(x, y-height);
  glVertex2i(x+width, y-height);
  glVertex2i(x+width, y);
  glVertex2i(x, y );
  glEnd();
}

void init(void) {

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0.0, 50.0, 0.0, 50.0);
}

void draw_truchet(int cx1, int cy1, int radius, int tile_no) {

	if( tile_no == 1 ) {
		draw_circ(cx1, cy1, 0.0, 90.0, radius);
		draw_circ(cx1+2*radius,cy1+2*radius,180.0,90.0, radius);
	}
	else{
		draw_circ(cx1, cy1+2*radius, 270.0, 90.0, radius);
		draw_circ(cx1+2*radius,cy1,90.0,90.0, radius);
	}

}

void display(void) {

	int cx1=1, cy1=1;
	int radius=24;
	int i, j;
	glClearColor(1.0, 1.0, 1.0, 1.0);
	glClear(GL_COLOR_BUFFER_BIT);
	glColor3f(0.0, 0.0, 0.0);
	
	for( i=0; i<10; i++)
		for(j=0;j<10;j++) {
			
			glViewport(i*50, j*50, 50, 50);	
			draw_truchet(cx1, cy1,radius, 1+rand()%2);
		}
		glFlush();
}

int main(int argc, char **argv) {
  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Truchet");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  glutDisplayFunc(display);
  init();
  glutMainLoop();

 return 0;
}
