#include <gl/glut.h>
#include <math.h>

void draw_circ(int cx, int cy, float sweep_angle, float angle, float radius) {

  const int n = 500;
  float ang = sweep_angle * 3.14159265/180;
  float ang_inc = angle * 3.14159265/(180*n);
  int k;
  glBegin(GL_POINTS);
  for(k=1; k <= n; k++, ang+=ang_inc) 
    glVertex2f((GLfloat)cx+radius*cos(ang), (GLfloat)cy+radius*sin(ang));
  glEnd();

}

void draw_rect(int x, int y, int width, int height) {

  glBegin(GL_LINE_STRIP);
  glVertex2i(x, y);
  glVertex2i(x, y-height);
  glVertex2i(x+width, y-height);
  glVertex2i(x+width, y);
  glVertex2i(x, y );
  glEnd();
}

void set_window(void) {

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0.0, 50.0, 0.0, 50.0);
}

void draw_orbit(float x, float y, float radius) {
  draw_circ(x, y, 0.0, 90.0, radius);
  draw_circ(x+radius, y, 90.0, 90.0, radius);
  draw_circ(x+radius, y+radius, 180.0, 90.0, radius);
  draw_circ(x, y+radius, 270.0, 90.0, radius);
}

void display(void) {

  int r=48.0;
  int x=1.0, y=1.0;
  int i, j;
  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);
  set_window();
  for(i=0; i<10; i++)
    for(j=0;j<10;j++) {

      glViewport(i*50, j*50, 50, 50);
      draw_rect(x, y+r, r, r);
      draw_orbit(1.0, 1.0, 48.0);
    } 
  glFlush();
}

int main(int argc, char **argv) {
  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Tiling 2");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  glutDisplayFunc(display);
  glutMainLoop();

 return 0;
}
