//#include <GL/gl.h>
//#include <GL/glu.h>
#include <gl/glut.h>
#include <math.h>

void draw_circ(int cx, int cy, float sweep_angle, float angle, float radius) {

  const int n = 500;
  float ang = sweep_angle * 3.14159265/180;
  float ang_inc = angle * 3.14159265/(180*n);
  int k;
  glBegin(GL_POINTS);
  for(k=1; k <= n; k++, ang+=ang_inc) 
    glVertex2f((GLfloat)cx+radius*cos(ang), (GLfloat)cy+radius*sin(ang));
  glEnd();

}

void draw_rect(int x, int y, int width, int height) {

  glBegin(GL_LINE_STRIP);
  glVertex2i(x, y);
  glVertex2i(x, y-height);
  glVertex2i(x+width, y-height);
  glVertex2i(x+width, y);
  glEnd();
}

void init(void) {

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0.0, 50.0, 0.0, 50.0);
  glViewport(0, 0, 500, 500);
}
void display(void) {

  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);

  draw_rect(10, 10, 10, 5);
  glFlush();
  draw_circ(15, 10, 0.0, 180.0, 5.0); 
  glFlush();

  draw_rect(30, 10, 10, 5);
  glFlush();
  draw_circ(30, 10, 0.0, 60.0, 10.0);
  glFlush();
  draw_circ(40, 10, 120.0, 60.0, 10.0);
  glFlush();

  draw_rect(10, 30, 10, 5);
  glFlush();
  draw_circ(15, 30, 0.0, 60.0, 5.0);
  glFlush();
  draw_circ(15, 30, 120.0, 60.0, 5.0);
  glFlush();
  draw_circ(10, 39, 300.0, 60.0, 5.0); /* 38.66 */
  glFlush();
  draw_circ(20, 39, 180.0, 60.0, 5.0);
  glFlush();

}

int main(int argc, char **argv) {
  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Keel");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  init();
  glutDisplayFunc(display);
  glutMainLoop();

 return 0;
}
