#ifndef __ENTITY_H__
#define __ENTITY_H__

#include "types.h"

/*
 * Oyunumuzda ekrana cizebilecegimiz her cisim Entity sinifindan turemek 
 * durumundadir. Bu sinif en temel cizilebilecek nesneyi tanimlar.
 *
 * move() metodu ile cisim otelenet,rek konumu degistirilebilir,
 * setPosition() ile direk olarak yeri degistirilebilirken,
 * getPosition() ile yeri ogrenilebilir.
 *
 * render() yordami pure virtual tanimlanmistir. Bu sekilde Entity
 * sinifindan direk olarak bir nesne uretilmesi engellenmistir. Ancak
 * Entity sinifini base sinif olarak kabul eden bir siniftan uretilen nesneler
 * bu sinifin yordamlarini kalitim yolu ile alarak kullanabilirler.
 * Ust sinif render() yordamini kendi istegine gore sekillendirmelidir.
 *
 * colRadius degiskeni entiy ler arasinda carpisma kontrolunde kullanilir, 
 * isHit yordami ile bir entity nin baska bir entity ye carpip carpmadigi
 * test edilebilir..
 */

class Entity {

public:

   Entity()  {};
   ~Entity() {};

   void  move(const Vec3d *delta);
   void  setPosition(float x,float y,float z);
   Vec3d getPosition() const;
   float getCollisionRadius() const;
   void  setCollisionRadius(float rad);
   bool  isHit(Entity *ent) const;

   virtual void render() = 0;
   virtual void update(float dt) {};

protected:

   Vec3d position;
   float colRadius;

};



#endif