#ifndef __PLAYER_H__
#define __PLAYER_H__

#include "ball.h"
#include "mine.h"

/*
 * Player sinifi ekrandaki oyuncularimizi belirtmekte kullanilir.
 * Bu sinifi direk olarak Entity sinifindan turetmek yerine icerisinde Entity
 * sinifindan turemis olan Ball sinifina ait bir nesne kullanma yolu
 * tercih edilmistir.
 *
 * Ball elemani oyuncunun goruntusunu olusturur, player sinifinin acceleration,
 * direction, speed, friction vb ozellikleri ise ball nesnesinin konumunu
 * degistirmede uygulanan hesaplamalarda kullanilmaktadir.
 *
 * updatePosition() yordami ile o anki tusa basilmalar ve gecen zaman dikkate
 * alinarak oyuncuya yeni bir yon, hiz ve konum verilmektedir.
 * hitToPlayer() ile oyuncularin birbirine carpip carpmadiklari kontrol edilir.
 * render() yordami ile basitce ball nesnesi ekrana cizdirilmektedir.
 *
 */

class Player {

public:
   Player();
   ~Player() {};

   Entity *getEntity() const;
   void   setDirection(float dirx,float diry,float dirz);
   Vec3d  getDirection();
   void   setPosition(float x,float y,float z);
   Vec3d  getPosition();
   void   setEnergy(float e);
   float  getEnergy();
   int    getScore();
   void   setScore(int scr);
   void   setFriction(float f);
   void   setSpeed(float s);
   float  getSpeed();
   void   setAcc(float a);
   float  getAcc();
   void   setMaxSpeed(float s);
   float  getMaxSpeed();
   void   setColor(float r,float g,float b);
   void   setSize(float size);
   float  getSize();

   void  updatePosition(bool n,bool s,bool e,bool w,float dt);
   void  render();

protected:

   Ball  ball;
   Vec3d dir;
   float speed;
   float acc;
   float friction;
   float maxSpeed;
   float energy;
   float size;
   int   score;

};


#endif