#include "arena.h"
#include <math.h>

Arena :: Arena(float radius) {
   
   setRadius(radius);
   quadratic = gluNewQuadric();
   gluQuadricNormals(quadratic,GLU_SMOOTH);
   //gluQuadricTexture(quadratic,GL_TRUE);

}

Arena :: ~Arena() {
   if (quadratic) gluDeleteQuadric(quadratic);
}

void Arena :: setRadius(int r) {
   radius = r;
}

bool Arena :: isOutside(Vec3d pos) {
   
   float dlen = sqrt(pos.x*pos.x+pos.y*pos.y+pos.z*pos.z);
   return (dlen > radius);
}

void Arena :: render() {

   glTranslatef(position.x,position.y,position.z);
   glRotatef(90,1,0,0);
   gluDisk(quadratic,0,radius,10,10);

}