//***********************************************************************//
//										                  								 //
//		- "Talk to me like I'm a 3 year old!" Programming Lessons -		    //
//                                                                       //
//		$Author:		DigiBen		digiben@gametutorials.com	         		 //
//															                  			 //
//		$Program:		Frustum Culling		          							 //
//																                  		 //
//		$Description:	Demonstrates checking if shapes are in view	   	 //
//													                  					 //
//		$Date:			8/28/01										            	 //
//	                  																	 //
//***********************************************************************//

#ifndef __FRUSTUM_H__
#define __FRUSTUM_H__

#include <lib3d/lib3d.h>
#include <math.h>

// We create an enum of the sides so we don't have to call each side 0 or 1.
// This way it makes it more understandable and readable when dealing with frustum sides.
enum FrustumSide
{
	RIGHT	= 0,		// The RIGHT side of the frustum
	LEFT	= 1,		// The LEFT	 side of the frustum
	BOTTOM	= 2,		// The BOTTOM side of the frustum
	TOP		= 3,		// The TOP side of the frustum
	BACK	= 4,		// The BACK	side of the frustum
	FRONT	= 5			// The FRONT side of the frustum
}; 

// Like above, instead of saying a number for the ABC and D of the plane, we
// want to be more descriptive.
enum PlaneData
{
	A = 0,				// The X value of the plane's normal
	B = 1,				// The Y value of the plane's normal
	C = 2,				// The Z value of the plane's normal
	D = 3				// The distance the plane is from the origin
};


class Frustum {

public:

	// Call this every time the camera moves to update the frustum
	void CalculateFrustum();

	// This takes a 3D point and returns TRUE if it's inside of the frustum
	bool PointInFrustum(float x, float y, float z);

	// This takes a 3D point and a radius and returns TRUE if the sphere is inside of the frustum
	bool SphereInFrustum(float x, float y, float z, float radius);

	// This takes the center and half the length of the cube.
	bool CubeInFrustum( float x, float y, float z, float size );

   bool Frustum::BoxInFrustum( float x, float y, float z, float x2, float y2, float z2);

private:

	// This holds the A B C and D values for each side of our frustum.
	float m_Frustum[6][4];

};

#endif
