////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////


#include "App.h"
#include "http.h"

// Programin giris noktasi. Hersey burda basliyor.
// Once bir PropReader nesnesi kullanilarak config.ini dosyasi icerisinden
// bazi konfigurasyon ve debug parametreleri okunuyor. Daha sonra bir App
// nesnesi yaratilip onemli parametreler setleniyor ve start() yordami cagirilarak
// ana oyun dongusune giriliyor.

int main(int argc,char **argv) {

   bool fullscreen = false;
   bool sound = true;
   int  default_w=800,default_h=600,default_mastervol=255;
   int  w,h;
   unsigned char mastervol;
   char scoreserver[256],scoreurl[256];
   sGameParams game_params;
   
   // config.ini icerisinden parametreleri oku   
   PropReader pr("config.ini");
   if (pr.getError() == 0) {
      fullscreen = (pr.getInt("fullscreen") == 0) ? false : true;
      sound = (pr.getInt("sound") == 0) ? false : true;
      w = pr.getInt("w");
      h = pr.getInt("h");
      if (w <= 0) w = default_w;
      if (h <= 0) w = default_h;
      mastervol = pr.getInt("mastervol");
      pr.getString("scoreserver",scoreserver);
      pr.getString("scoreurl",scoreurl);
      game_params.life = pr.getFloat("d_life");
      if (game_params.life < 0)
         game_params.life = 0;
      
      game_params.base_head_fork_time = pr.getFloat("d_base_head_fork_time");
      if (game_params.base_head_fork_time <= 0)
         game_params.base_head_fork_time = BASE_HEAD_FORK_TIME;
      game_params.fork_time_delta_scaling = pr.getFloat("d_fork_time_delta_scaling");
      if (game_params.fork_time_delta_scaling <= 0)
         game_params.fork_time_delta_scaling = FORK_TIME_DELTA_SCALING;
      game_params.max_trap_count = pr.getInt("d_max_trap_count");
      if (game_params.max_trap_count <= 0)
         game_params.max_trap_count = MAX_TRAP_COUNT;
      game_params.trap_life_time = pr.getFloat("d_trap_life_time");
      if (game_params.trap_life_time <= 0)
         game_params.trap_life_time = TRAP_LIFE_TIME;
      game_params.time_between_hbonus = pr.getFloat("d_time_between_hbonus");
      if (game_params.time_between_hbonus <= 0)
         game_params.time_between_hbonus = TIME_BETWEEN_HBONUS;
      game_params.time_between_dbonus = pr.getFloat("d_time_between_dbonus");
      if (game_params.time_between_dbonus <= 0)
         game_params.time_between_dbonus = TIME_BETWEEN_DBONUS;
      game_params.showFps = pr.getInt("d_showfps") == 1 ? true : false;
   }
   else {
      w = default_w;
      h = default_h;
      mastervol = default_mastervol;
   }
   
   App app;
   //app.showFPS(true);
   app.setTitle("Ruh Kapani v "VERSION_STR);
   //app.enableSimpleCamera(true);
   app.setSize(w,h);
   app.setFullScreen(fullscreen);  
   app.setNetworkParams(scoreserver,scoreurl);
   app.setSoundParams(sound,mastervol);
   app.setGameParams(game_params);
   
   // ana oyun dongusu baslar..
   app.start();

   return 0;
}