#ifndef __BEZIERPATH_H__
#define __BEZIERPATH_H__

#pragma warning (disable : 4786)

#include <vector>
#include <lib3d/util3d/vector3d.h>

using namespace std;

class BezierPath {

public:

   BezierPath();
   BezierPath(Vector3d p0,Vector3d p1,Vector3d p2,Vector3d p3);
   ~BezierPath();

   void setControlPoints(Vector3d p0,Vector3d p1,Vector3d p2,Vector3d p3);
   void setControlPoint(Vector3d p,int pointNum);
   void setDensity(int d);
   int  getDensity();
   void calculate();
   void getPointOnCurve(Vector3d *p,int pnum);
   void getAllPointsOnCurve(Vector3d *p[]);

private:

   vector<Vector3d> pointVector;
   Vector3d cpoints[4];
   int density;

};



#endif