#ifndef __PARTICLE_H__
#define __PARTICLE_H__

#include <stdlib.h>
#include <time.h>

#include <lib3d/util3d/Vector3d.h>
#include <lib3d/util2d/Texture.h>
#include <lib3d/util2d/ColorVec.h>

struct pEnt {
   float lifeTime;
   Vector3d acc;
   Vector3d vel;
   Vector3d pos;
   ColorVec color;
};



class Particle {

public:
   Particle(int maxPartCount);
   virtual ~Particle();

   void setTexture(Texture *tex);
   void setGravity(float x,float y,float z);
   Vector3d getGravity();
   void setFountain(bool f);
   void setColor(int pindex,float r,float g,float b);
   ColorVec getColor(int pindex);
   void setMaxSpeed(float maxs);
   float getMaxSpeed();
   void  setParameters(Vector3d center,Vector3d maxVel,Vector3d minVel,
                             Vector3d maxAcc,Vector3d minAcc,float maxR);

   virtual void update(float dt);
   virtual void render();

   
   void addRandomEntities(int count,Vector3d center,Vector3d maxVel,Vector3d minVel,
                                     Vector3d maxAcc,Vector3d minAcc,float maxPosRadius);

protected:

   void addRandomEntity(Vector3d center,Vector3d maxVel,Vector3d minVel,Vector3d maxAcc,
                                           Vector3d minAcc,float maxPosRadius,int index);
   void addEntity(int index,Vector3d pos,Vector3d vel,Vector3d acc);
   void changeEntitiy(int e,Vector3d pos,Vector3d vel,Vector3d acc);
      
   
   pEnt *particles;
   int  maxPartCount;
   int  partCount;
   float maxSpeed;
   Vector3d gravity;
   Vector3d minVel, maxVel, minAcc, maxAcc, center;
   float maxRadius;
   bool  isFountain;

   Texture *tex;
   

};

#endif