////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __healthbonus_h__
#define __healthbonus_h__

#pragma warning (disable : 4786)

#include "MovingObject.h"
#include <lib3d/util2d/Particle.h>
#include <lib3d/model/loader/MSAsciiLoader.h>

// MovingObject den tureyen bir bonus sinifidir.
// Hareket ozelligine sahip degil. updated() icerisinde cesitli durumlari
// arasinda gecis yapiyor. render() ile ekrana ciziliyor.
// kendi icerisinde bulunan basit bir particle engine de sahip.

class HealthBonus : public MovingObject {

public:  
   
   enum eHealthBonusState { HBS_DEACTIVATED=0, HBS_ACTIVATED, HBS_FINISHED };
   
   HealthBonus();

   eHealthBonusState getState() { return hbstate; }
   void setState(eHealthBonusState s) {
      hbstate = s;
      if (s==HBS_ACTIVATED)
         activation_time = dtime;
   };

   virtual void init();
   virtual void update(float dt);
   virtual void render();

protected:
   
   eHealthBonusState hbstate;
   float activation_time;

   static bool first_init;
   static Model *model;

   Particle *pengine;

};


#endif