#ifndef __MODELTYPES_H__
#define __MODELTYPES_H_

#pragma warning (disable : 4786)

#include <lib3d/util2d/Texture.h>
#include <lib3d/util2d/ColorVec.h>
#include <lib3d/util3d/Vector3d.h>

#define NAME_LEN 16

struct tVertex {
   float x,y,z;
};

struct tUV {
   float u,v;
};

struct tFace {
   int v[3];
   int n[3];
   int uv[3];
};

struct tMaterial {
   
   ColorVec ambient;
   ColorVec diffuse;
   ColorVec specular;
   ColorVec emissive;
   float    shininess;
   float    transparency;
   Texture  *texture;
   
};

struct tMesh {
   
   tFace     *faces;
   tVertex   *vertices;
   tUV       *uvs;
   Vector3d  *normals;

   int faceCount;
   int vertexCount;
   int uvCount;
   int normalCount;
   int materialIndex;
   Vector3d boundingBox;
   float boundingSphereRad;
   char name[NAME_LEN];
   
};



#endif