#ifndef __ANIMATED_MODEL_H__
#define __ANIMATED_MODEL_H__

#pragma warning (disable : 4786)

#include <lib3d/model/model.h>

struct tAnimation {
   int  firstFrame;
   int  lastFrame;
   int  currSourceFrame;
   int  currDestFrame;
   char name[NAME_LEN];
};



class AnimatedModel : public Model {

public:

   AnimatedModel();
   AnimatedModel(Model *model);
   ~AnimatedModel();

   void  activeAnimation(int animNum,bool oneShot=false);
   int   getActiveAnimation() const;
   int   getAnimationCount() const;
   int   getCurrentSourceMeshIndex() const;
   int   getCurrentDestMeshIndex() const;
   Vector3d getBoundingBox();
   float getBoundingSphere();
   void  setLooping(bool b);
   void  setStopped(bool b);
   void  setSpeed(float fac);
   void  animate(float dt);
   
   void  render();

   void  setAnimations(tAnimation *anims,int animCount);

private:

   void render_textured(Texture *texture) const;
   void render_untextured() const;

   tAnimation *anims;
   int animCount;
   int activeAnim;
   int lastAnim;
   float time;
   bool looped;
   bool stopped;
   bool oneShot;
   float anim_dt;
   float animSpeedFactor;
   

};




#endif