////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "Intro.h"

Intro::Intro() {
}

void Intro::init() {

   terrTex = new Texture("data/detail2.jpg");
   terrTex->build();
   logoTex = new Texture("data/logo.png");
   logoTex->build();

   restart();
}

void Intro::restart() {

   useNoise = false;
   timet = 0;
   finish_t = 0;
   isFinished = false;
   finish_sequence = false;

   headList.clear();
   for (int i=0;i<20;++i) {
      Head *h = new Head;
      float rx = ((rand()%8)-2)*30;
      float ry = (rand()%8)*10;
      float rz = ((rand()%9)-4)*20;
      h->setPos(Vector3d(rx,-ry,rz));
      h->setTarget(Vector3d(rx,100.0f,rz));
      h->init();
      h->enableParticles(false);
      h->setSpeed(0.1f);
      h->setState(Head::HS_MOVING);
      h->setType(Head::HT_BONES);
      headList.push_back(h);
   }

}

void Intro::finish() {
   finish_t = 0;
   finish_sequence = true;
}

void Intro::update(float dt) {
   timet += dt;
   
   if (finish_sequence) {
      finish_t += dt;
      if (finish_t >= 2.0f) {
         isFinished = true;
         headList.clear();
      }
   }

   list<Head*>::iterator hi = headList.begin();
   while (hi != headList.end()) {
      Head *h = *hi;
      if (h->getState() == Head::HS_ATTARGET) {
         float rx = ((rand()%8)-2)*30;
         float ry = (rand()%8)*10;
         float rz = ((rand()%9)-4)*20;
         h->setPos(Vector3d(rx,-ry,rz));
         h->setTarget(Vector3d(rx,100.0f,rz));
         h->setState(Head::HS_MOVING);
         ((MovingObject*)h)->setState(MovingObject::MOS_MOVING);
         h->setSpeed(0.1f);
      }

      h->update(dt);
      ++hi;
   }
   
}

void Intro::render() {

   if (useNoise == false) {
      if (rand()%1000 == 0) {
         useNoise = true;
         noiseTime = timet;
      }
   }
   else {
      if (timet - noiseTime >= 1.0f) {
         useNoise = false;
      }
   }


   glPushMatrix();
   glRotatef(timet*5,0,1,0);   

   glDisable(GL_LIGHTING);
   glColor3ub(167,88,25);
   glRotatef(-90,1,0,0);
   const float sz = 500;
   terrTex->begin();
   glBegin(GL_QUADS);
   glTexCoord2f(0,0); glVertex3f(-sz,-sz,0);
   glTexCoord2f(10,0); glVertex3f(sz,-sz,0);
   glTexCoord2f(10,10); glVertex3f(sz,sz,0);
   glTexCoord2f(0,10); glVertex3f(-sz,sz,0);
   glEnd();
   terrTex->end();
   glPopMatrix();
   glEnable(GL_LIGHTING);

   glDisable(GL_DEPTH_TEST);
   glDisable(GL_LIGHTING);
   glEnable(GL_BLEND);
   glDisable(GL_FOG);
   glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_ALPHA);
   glColor3f(sin(timet),1,1);
   glPushMatrix();
   if (!useNoise)
      glTranslatef(0+finish_t*0,55+finish_t*20,90+finish_t*40);
   else
      glTranslatef(sin(timet)+finish_t*0,55+cos(timet)+finish_t*20,90+finish_t*40);
   glScalef(40,40,40);
   const float lsz = 1;
   logoTex->begin();

   glBegin(GL_QUADS);
   glTexCoord2f(0,0); glVertex3f(-lsz,-lsz,0);
   glTexCoord2f(1,0); glVertex3f(lsz,-lsz,0);
   glTexCoord2f(1,1); glVertex3f(lsz,lsz,0);
   glTexCoord2f(0,1); glVertex3f(-lsz,lsz,0);
   glEnd();
   logoTex->end();
   glPopMatrix();
   glDisable(GL_BLEND);
   glEnable(GL_LIGHTING);
   glEnable(GL_FOG);
   glEnable(GL_DEPTH_TEST);

   glPushMatrix();
   glRotatef(-90,0,1,0);
   list<Head*>::iterator hi = headList.begin();
   while (hi != headList.end()) {
      (*hi)->render();
      ++hi;
   }
   glPopMatrix();


}