////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "DestroyerBonus.h"

bool   DestroyerBonus::first_init = true;
Model* DestroyerBonus::model = NULL;
Billboard* DestroyerBonus::billboard = NULL;

DestroyerBonus::DestroyerBonus() {
   motype = MOT_DBONUS;
}

void DestroyerBonus::init() {

   MovingObject::init();
   
   if (DestroyerBonus::first_init) {      
      DestroyerBonus::model = MSAsciiLoader::instance()->load("data/powerup2.txt");
      DestroyerBonus::model->build();

      Texture *billtex = new Texture("data/fire.shader");
      billtex->build();
      billboard = new Billboard(billtex);

      DestroyerBonus::first_init = false;
   }
   
   pengine = new Particle(100);
   Texture *ptex = new Texture("data/particle.tga");
   ptex->build();
   pengine->setTexture(ptex);

   const float particleWidth = 1.0f * 0.2f;
   const float particleLength = particleWidth;
   Vector3d center(0.0f,5.0f,0.0f);
   Vector3d minVel(-particleWidth,-particleWidth,-particleWidth);
   Vector3d maxVel(particleWidth,particleLength,particleWidth);
   Vector3d minAcc(0.0f,0.0f,0.0f);
   Vector3d maxAcc(0.0f,0.0f,0.0f);
   
   pengine->setParameters(center,maxVel,minVel,maxAcc,minAcc,0.1f);
   pengine->addRandomEntities(100,center,maxVel,minVel,maxAcc,minAcc,0.1f);
   for (int i=0;i<100;++i) {
      pengine->setColor(i,i,1,1);
   }

   pengine->setFountain(true);

   speed = 0;
   dtarget_cnt = 0;
   mostate = MovingObject::MOS_WAITINGWP;
   dbstate = DBS_DEACTIVATED;

}

void DestroyerBonus::update(float dt) {

   MovingObject::update(dt);
   pengine->update(dt);

   
   if (dbstate == DBS_ACTIVATED) {
      float dt = dtime - activation_time;
      if (dt > 4)
         dbstate = DBS_FINISHED;
   }
   

}

void DestroyerBonus::render() {
   
   float dt;
   if (dbstate == DBS_ACTIVATED)
      dt = dtime - activation_time;
   else
      dt = 0;

   glPushMatrix();
   glTranslatef(pos.x,pos.y-dt*5,pos.z);
   //glRotatef(90,1,0,0);
   //glRotatef(90,0,0,1);
   glDisable(GL_LIGHTING);
   glDisable(GL_FOG);
   glEnable(GL_BLEND);
   glBlendFunc(GL_ONE,GL_ONE);
   glColor3f(0.7f,0,0);
   model->render();
   glPopMatrix();

   glBlendFunc(GL_SRC_ALPHA,GL_ONE);
   glDisable(GL_DEPTH_TEST);
   glColor4f(1,1,1,(sin(dt*M_PI/2-M_PI/2)+1)*0.5);
   if (dbstate == DBS_ACTIVATED) {
      for (int i=0;i<dtarget_cnt;++i) {
         glPushMatrix();
         glTranslatef(targetPos[i].x,targetPos[i].y,targetPos[i].z);
         glScalef(20,25,20);
         glTranslatef(0,0.5f,0);
         billboard->render();
         glPopMatrix();
      }
      /*
      glPushMatrix();
      glTranslatef(pos.x,pos.y+10,pos.z);
      glScalef(10,25,20);
      glTranslatef(0,0.5f,0);
      billboard->render();
      glPopMatrix();
      */
   }
   glEnable(GL_DEPTH_TEST);
   
   glDisable(GL_BLEND);
   glEnable(GL_LIGHTING);
   glEnable(GL_FOG);
   glPopMatrix();
}

