////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __app_h__
#define __app_h__

#include <lib3d/App/BaseApp.h>
#include <lib3d/terrain/terrain.h>
#include <lib3d/model/loader/MSAsciiLoader.h>
#include <lib3d/util2d/Particle.h>
#include <lib3d/util/PropReader.h>
#include "glfont.h"
#include <time.h>

#include "HighResTimer.h"
#include "Head.h"
#include "Target.h"
#include "Trap.h"
#include "Intro.h"
#include "HealthBonus.h"
#include "DestroyerBonus.h"
#include "SoundManager.h"
#include "UI.h"
#include "http.h"

#include <list>
using namespace std;

#define VERSION_STR               "0.1"
#define LIFE                      10.0f
#define BASE_HEAD_FORK_TIME        5.0f
#define MAX_TRAP_COUNT               3
#define TRAP_LIFE_TIME             5.0f
#define FORK_TIME_DELTA_SCALING    0.2f
#define TIME_BETWEEN_HBONUS       50.0f
#define TIME_BETWEEN_DBONUS       60.0f

struct sGameParams {
   float life;
   float base_head_fork_time;
   int   max_trap_count;
   float trap_life_time;
   float fork_time_delta_scaling;
   float time_between_hbonus;
   float time_between_dbonus;
   bool  showFps;
};

class App : public BaseApp, UIOwner {

public:

   enum eGameState { GS_INTRO, GS_INTRO_TO_GAME, GS_GAME, GS_GAME_TO_END, GS_GAME_END, GS_RENDER_SCORES,
                     GS_ENTER_NAME, GS_NOHIGHSCORE };

   App();
   
   void setState(eGameState s) { state = s; };
   eGameState getState() { return state; };

   void onInit();

   void onExit() {
      saveScoresToDisk();
      glFontDestroy(&font);
      soundman.destroy();
   }

   void onKeyPressed(const SDLKey &key);

   void onMouseButtonPressed(int button,int scrx,int scry) {
      if (trapCount < gameParams.max_trap_count) {
         addTrap();
         ++trapCount;
      }

      ++curr_total_mouse_press;
   }

   void setNetworkParams(const char *scoreserver,const char *scoreurl) {
      strcpy(this->scoreserver,scoreserver);
      strcpy(this->scoreurl,scoreurl);
   }
   void setSoundParams(bool enable,unsigned char mastervol) {
      soundman.mute(!enable);
      soundman.setMasterVolume(mastervol);
   }
   void setGameParams(sGameParams params);

   void UIEvent_Callback(UIEvent *event);

   void onRender();

protected:

   void buildUI();
   void resetScores();
   void loadScoresFromDisk();
   void saveScoresToDisk();
   void renderIntro(float dt);
   void renderGame(float dt);
   void renderDamagedScreen();
   void renderConsol();
   void handleScoreTable();
   void restartGame();
   void runGameLogic(float dt);
   void handle_mainMenuEvents(UIEvent *event);
   void handle_sguncelleMenuEvents(UIEvent *event);
   void handle_highscoreEvents(UIEvent *event);
   void addTrap();
   void setShadowMatrix(float fDestMat[16],const float fLightPos[4],const float fPlane[4]);

   Intro intro;
   HighResTimer timer;
   Terrain *terrain;
   Target *target;
   list<Head*> headList;
   list<Trap*> trapList;
   list<MovingObject*> bonusList;
   Texture *damageTex;
   Texture *terrTex;
   GLFONT font;
   SoundManager soundman;

   bool  shake_screen;
   float shake_time;
   int   trapCount;
   eGameState state;
   int   life;
   float timet;
   float game_start_time;
   float score;
   float game_end_begint;
   int   hs_rank;
   float cftime;
   float hbonus_ftime;
   float dbonus_ftime;
   sGameParams gameParams;

   char  hs_name[10][16];
   float hs_score[10];
   char  scoreserver[256];
   char  scoreurl[256];
   // some vars for statistics and security 
   int total_forked_head_count[10];    // for each score entry
   int total_forked_bonus_count[10];
   int total_mouse_press[10];
   int curr_total_forked_head_count;
   int curr_total_forked_bonus_count;
   int curr_total_mouse_press;

   UIManager ui;
   UIGfxMenu *gmenu;
   UIGfxMenu *sguncelleMenu;
   UILabel *timeLabel;
   UILabel *fpsLabel;
   UILabel *versionLabel;
   UIPanel *aboutPanel;
   UIPanel *scoreNamesPanel;
   UIPanel *scoreScoresPanel;
   UIPanel *congratulationsPanel;
   char    about_lines[10][255];
   UILabel *aboutLabels[10];
   UILabel *scoreNameLabels[10];
   UILabel *scoreScoreLabels[10];
   UIEdit  *hsedit;
   UIPanel *nohighscorePanel;

};




#endif