#ifndef __q3bsp_types_h__
#define __q3bsp_types_h__

#include <lib3d/util/CBitset.h>

#define FACE_POLYGON    1
#define FACE_PATCH      2
#define FACE_MESH       3
#define FACE_BILLBOARD	4

#define MAX_TEXTURE_COUNT 1024

enum q3bsp_eLumps
{
    kEntities = 0,				// Stores player/object positions, etc...
    kTextures,					// Stores texture information
    kPlanes,				    // Stores the splitting planes
    kNodes,						// Stores the BSP nodes
    kLeafs,						// Stores the leafs of the nodes
    kLeafFaces,					// Stores the leaf's indices into the faces
    kLeafBrushes,				// Stores the leaf's indices into the brushes
    kModels,					// Stores the info of world models
    kBrushes,					// Stores the brushes info (for collision)
    kBrushSides,				// Stores the brush surfaces info
    kVertices,					// Stores the level vertices
    kMeshVerts,					// Stores the model vertices offsets
    kShaders,					// Stores the shader files (blending, anims..)
    kFaces,						// Stores the faces for the level
    kLightmaps,					// Stores the lightmaps for the level
    kLightVolumes,				// Stores extra world lighting information
    kVisData,					// Stores PVS and cluster info (visibility)
    kMaxLumps					// A constant to store the number of lumps
};


struct q3bsp_tBSPHeader
{
    char strID[4];				// This should always be 'IBSP'
    int version;				// This should be 0x2e for Quake 3 files
}; 


struct q3bsp_tBSPLump
{
	int offset;					// The offset into the file for the start of this lump
	int length;					// The length in bytes for this lump
};


struct q3bsp_tBSPVertex
{
    float vPosition[3];			// (x, y, z) position. 
    float vTextureCoord[2];		// (u, v) texture coordinate
    float vLightmapCoord[2];	// (u, v) lightmap coordinate
    float vNormal[3];			// (x, y, z) normal vector
    unsigned char color[4];				// RGBA color for the vertex 
};


struct q3bsp_tBSPFace
{
    int textureID;				// The index into the texture array 
    int effect;					// The index for the effects (or -1 = n/a) 
    int type;					// 1=polygon, 2=patch, 3=mesh, 4=billboard 
    int startVertIndex;			// The starting index into this face's first vertex 
    int numOfVerts;				// The number of vertices for this face 
    int meshVertIndex;			// The index into the first meshvertex 
    int numMeshVerts;			// The number of mesh vertices 
    int lightmapID;				// The texture index for the lightmap 
    int lMapCorner[2];			// The face's lightmap corner in the image 
    int lMapSize[2];			// The size of the lightmap section 
    float lMapPos[3];			// The 3D origin of lightmap. 
    float lMapVecs[2][3];		// The 3D space for s and t unit vectors. 
    float vNormal[3];			// The face normal. 
    int size[2];				// The bezier patch dimensions. 
};


struct q3bsp_tBSPTexture
{
    char strName[64];			// The name of the texture w/o the extension 
    int flags;					// The surface flags (unknown) 
    int contents;				// The content flags (unknown)
};

struct q3bsp_tBSPLightmap
{
    unsigned char imageBits[128][128][3];   // The RGB data in a 128x128 image
};


struct q3bsp_tBSPNode
{
    int plane;					// The index into the planes array 
    int front;					// The child index for the front node 
    int back;					// The child index for the back node 
    int min[3];				// The bounding box min position. 
    int max[3];				// The bounding box max position. 
}; 

struct q3bsp_tBSPLeaf
{
    int cluster;				// The visibility cluster 
    int area;					// The area portal 
    int min[3];				// The bounding box min position 
    int max[3];				// The bounding box max position 
    int leafface;				// The first index into the face array 
    int numOfLeafFaces;			// The number of faces for this leaf 
    int leafBrush;				// The first index for into the brushes 
    int numOfLeafBrushes;		// The number of brushes for this leaf 
}; 

struct q3bsp_tBSPPlane
{
    float vNormal[3];			// Plane normal. 
    float d;					// The plane distance from origin 
};

struct q3bsp_tBSPVisData
{
	int numOfClusters;			// The number of clusters
	int bytesPerCluster;		// The amount of bytes (8 bits) in the cluster's bitset
	unsigned char *pBitsets;				// The array of bytes that holds the cluster bitsets				
};

struct q3bsp_tBSPBrush 
{
   int brushSide;           // The starting brush side for the brush 
   int numOfBrushSides;     // Number of brush sides for the brush
   int textureID;           // The texture index for the brush
};

struct q3bsp_tBSPBrushSide 
{
   int plane;              // The plane index
   int textureID;          // The texture index
}; 


#endif