////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "Target.h"

static Texture ttex("data/target.shader");

Target :: Target() {

   ttex.build();
   
   location.pos.zero();
   location.yangle = 0;
   setSpeed(0.2f);
   setScale(40);
   setLocked(false);

}

void Target :: setSpeed(float s) {
   speed = s;
}

void Target :: setLocked(bool b) {
   
   Stage *shaders = ttex.getStages();

   locked = b;
   if (locked) {
      shaders[0].rot_speed = 1000;
      //tscale = 12;
   }
   else {
      shaders[0].rot_speed = 30;
      //tscale = 7;
   }

}

bool Target :: getLocked() {
   return locked;
}

void Target :: setScale(float s) {
   tscale = s;
}

float Target :: getScale() {
   return tscale;
}

void Target :: updateMouseCoordinates(int deltax,int deltay) {
   location.strafeRight(deltax*speed);
   location.moveBackward(deltay*speed);
}

Vector3d Target :: getBoundingBox() {
   Vector3d bb(tscale/2,tscale/2,tscale/2);
   return bb;
}

float Target :: getBoundingSphere() {
   return tscale/2;
}

void Target :: render() {
      
      
   //glDisable(GL_DEPTH_TEST);
   //glDepthMask(false);
   glEnable(GL_BLEND);
   glBlendFunc(GL_SRC_ALPHA,GL_ONE);
   glTranslatef(-0.5,10,-0.5);
   glScalef(tscale,tscale,tscale);
   glRotatef(-90,1,0,0);
   ttex.render();
   glDisable(GL_BLEND);
   //glDepthMask(true);
   //glEnable(GL_DEPTH_TEST);
      
   //glScalef(tscale,tscale,tscale);
 
}

