////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#include "Head.h"


bool   Head::first_init = true;
Model* Head::model = NULL;
Billboard* Head::bb = NULL;

Head::Head() {
   recalc = true;
   radius = 10.0f;
   speed = 1.0f;
   enablePart = true;
   headtype = HT_BONES;
   dtime = 0;
   dead_start_time = 0;
   motype = MOT_HEAD;
}

Head::~Head() {
   delete pengine;
}

void Head::init() {

   if (Head::first_init) {      
      Head::model = MSAsciiLoader::instance()->load("data/head.txt");
      Head::model->build();

      Texture *btex = new Texture("data/fire.shader");
      btex->build();
      bb = new Billboard(btex);
      
      Head::first_init = false;

   }

   pengine = new Particle(100);
   Texture *ptex = new Texture("data/particle.shader");
   ptex->build();
   pengine->setTexture(ptex);

   const float particleWidth = 0.2f * 0.2f;
   const float particleLength = 1.0f * 0.2f;
   Vector3d center(0.0f,0.0f,0.0f);
   Vector3d minVel(-particleWidth,-0.10f,-particleWidth);
   Vector3d maxVel(particleWidth,-particleLength,particleWidth);
   Vector3d minAcc(0.0f,0.0f,0.0f);
   Vector3d maxAcc(0.0f,0.0f,0.0f);
   
   pengine->setParameters(center,maxVel,minVel,maxAcc,minAcc,0.1f);
   pengine->addRandomEntities(100,center,maxVel,minVel,maxAcc,minAcc,0.1f);
   for (int i=0;i<100;++i) {
      pengine->setColor(i,i,1.0f/i,1.0f/i);
      //pengine->setColor(1,1,1,1);
   }

   pengine->setFountain(true);
   state = HS_DEPLOYING;

}

void Head::update(float dt) {
   
   MovingObject::update(dt);
   
   if (recalc) {
      recalculateDeltaVector();
      recalc = false;
      
      if (mostate == MOS_MOVING) {
      
         Vector3d target = getTarget();
         
         Vector3d zplus(0,0,1);
         Vector3d dir(target.x-pos.x,target.y-pos.y,target.z-pos.z);
         dir.normalize();
         heading_angle = zplus.angle(&dir);
         if (target.x < pos.x)
            heading_angle = -heading_angle;

      }

   }

   if (state == HS_DEPLOYING) {
      pos.y += dt * 20.0f;
      if (pos.y >= 10) {
         pos.y = 10;
         state = HS_MOVING;
      }
   }
   else
   if (state == HS_MOVING || state == HS_DYING) {
      
      //MovingObject::setState(MOS_MOVING);
      //moveToTarget(dt);

      if (mostate == MOS_WAITINGWP) {
         if (state == HS_DYING)
            state = HS_STOPPED;
         else
            state = HS_ATTARGET;
      }

      if (state == HS_DYING) {
         heading_angle += dtime * 0.3f;
      
         if (dead_start_time == 0)
            dead_start_time = dtime;

      }

      

   }

   if (enablePart)
      pengine->update(dt);

}

void Head :: onWaypoint(int idx) {
}

void Head::render() {
   
   float dead_dt = dtime - dead_start_time;
   float dead_alpha = 0.0f;
   
   if (state == HS_DYING) {
      dead_alpha = dead_dt * 0.8f;
   }
   else
   if (state == HS_STOPPED)
      dead_alpha = 1.0f;
   
   glPushMatrix();
   glTranslatef(pos.x,pos.y,pos.z);
   glRotatef(heading_angle,0,1,0);
   
   glEnable(GL_BLEND);
   //glBlendFunc(GL_ONE,GL_ONE);
   glBlendFunc(GL_SRC_ALPHA,GL_ONE);
   glDisable(GL_LIGHTING);
   glDisable(GL_FOG);
   
   if (headtype == HT_GREEN) {
      glColor4f(0.1f,1.0f,0.1f,1.0f - dead_alpha);
   }
   else
   if (headtype == HT_BLACK) {
      glColor4f(0.8f,0.0f,0.0f,1.0f - dead_alpha);
   }
   else
   if (headtype == HT_AVOIDMAN) {
      glColor4f(0.1f,0.1f,1.0f,1.0f - dead_alpha);
   }
   else {
      glDisable(GL_BLEND);
      glColor4f(1.0f,1.0f,1.0f,1.0f);
   }
   
   
   model->render();
   
   glPushMatrix();
   glTranslatef(0,9,0);
   glScalef(5,5,5);
   glEnable(GL_BLEND);
   //glBlendFunc(GL_ONE,GL_ONE);
   glBlendFunc(GL_SRC_ALPHA,GL_ONE);
   glDisable(GL_FOG);
   glDisable(GL_LIGHTING);
   glDisable(GL_DEPTH_TEST);
   glColor4f(1,1,1,1 - dead_alpha);
   bb->render();
   glEnable(GL_DEPTH_TEST);
   glPopMatrix();

   if (enablePart)
      pengine->render();
   glPopMatrix();

   glDisable(GL_BLEND);
   glEnable(GL_LIGHTING);
   glEnable(GL_FOG);
}

void Head :: renderSilhouette() {
   glPushMatrix();
   glTranslatef(pos.x,pos.y,pos.z);
   glRotatef(heading_angle,0,1,0);
   
   model->render();
   
   glPopMatrix();
}

