#include <lib3d/util3d/Quaternion.h>
#include <math.h>

Quaternion :: Quaternion() {
}

Quaternion :: Quaternion(float x,float y,float z,float w) {
   set(x,y,z,w);
   normalize();
}

Quaternion :: Quaternion(Quaternion *q1,Quaternion *q2,float interpolation) {
   slerp(q1,q2,interpolation);
}

Quaternion :: ~Quaternion() {
}

void Quaternion :: set(Quaternion *q) {
   set(q->x,q->y,q->z,q->w);
}

void Quaternion :: set(float x,float y,float z,float w) {
   this->x = x;
   this->y = y;
   this->z = z;
   this->w = w;
}

void Quaternion :: reset() {
   set(0,0,0,1);
}


float Quaternion :: magnitude() {
   return (float) sqrt(x*x+y*y+z*z+w*w);
}

void Quaternion :: normalize() {
   float mag = magnitude();
   x /= mag;
   y /= mag;
   z /= mag;
   w /= mag;
}

void Quaternion :: invert() {
   x = -x;
   y = -y;
   z = -z;
   w = -w;
}

void Quaternion :: createFromAxisAngle(Vector3d *axis,float angle) {
   createFromAxisAngle(axis->x,axis->y,axis->z,angle);
}

void Quaternion :: createFromAxisAngle(float x,float y,float z,float angle) {

   float rad = (float) ((angle/180.0f)*M_PI);
   float result = (float) sin(rad/2.0f);
   
   w = (float) cos(rad/2.0f);
   this->x = x * result;
   this->y = y * result;
   this->z = z * result;

}

void Quaternion :: createMatrix(float *pMatrix) {

   pMatrix[0] = 1.0f - 2.0f * ( y * y + z * z );  
   pMatrix[1] = 2.0f * ( x * y - w * z );  
   pMatrix[2] = 2.0f * ( x * z + w * y );  
   pMatrix[3] = 0.0f;  
   pMatrix[4] = 2.0f * ( x * y + w * z );  
   pMatrix[5] = 1.0f - 2.0f * ( x * x + z * z );  
   pMatrix[6] = 2.0f * ( y * z - w * x );  
   pMatrix[7] = 0.0f;  
   pMatrix[8] = 2.0f * ( x * z - w * y );  
   pMatrix[9] = 2.0f * ( y * z + w * x );  
   pMatrix[10] = 1.0f - 2.0f * ( x * x + y * y );  
   pMatrix[11] = 0.0f;  
   pMatrix[12] = 0;  
   pMatrix[13] = 0;  
   pMatrix[14] = 0;  
   pMatrix[15] = 1.0f;

}

void Quaternion :: slerp(Quaternion *q1,Quaternion *q2,float interpolation) {

   float a,b;

   a = ( q1->x-q2->x )*( q1->x-q2->x ) + ( q1->y-q2->y )*( q1->y-q2->y ) + 
       ( q1->z-q2->z )*( q1->z-q2->z ) + ( q1->w-q2->w )*( q1->w-q2->w );
   b = ( q1->x+q2->x )*( q1->x+q2->x ) + ( q1->y+q2->y )*( q1->y+q2->y ) + 
       ( q1->z+q2->z )*( q1->z+q2->z ) + ( q1->w+q2->w )*( q1->w+q2->w );


   if ( a > b )
      q2->invert();

   float cosom = q1->x*q2->x+q1->y*q2->y+q1->z*q2->z+q1->w*q2->w;
   double sclq1, sclq2;

   if (( 1.0+cosom ) > 0.00000001 ) {
      if (( 1.0-cosom ) > 0.00000001 ) {
         double omega = acos( cosom );
         double sinom = sin( omega );
         sclq1 = sin(( 1.0-interpolation )*omega )/sinom;
         sclq2 = sin( interpolation*omega )/sinom;
      }
      else {
         sclq1 = 1.0-interpolation;
         sclq2 = interpolation;
      }

      x = ( float )( sclq1*q1->x+sclq2*q2->x );
      y = ( float )( sclq1*q1->y+sclq2*q2->y );
      z = ( float )( sclq1*q1->z+sclq2*q2->z );
      w = ( float )( sclq1*q1->w+sclq2*q2->w );
   }
   else {
      x = -q1->y;
      y = q1->x;
      z = -q1->w;
      w = q1->z;

      sclq1 = sin(( 1.0-interpolation )*0.5*M_PI );
      sclq2 = sin( interpolation*0.5*M_PI );

      x = ( float )( sclq1*q1->x+sclq2*x );
      y = ( float )( sclq1*q1->y+sclq2*y );
      z = ( float )( sclq1*q1->z+sclq2*z );
   }

}
