#include <lib3d/util2d/TextureManager.h>

TextureManager :: TextureManager() {
}

TextureManager :: ~TextureManager() {
   texIdMap.clear();
}

TextureManager* TextureManager :: instance() {
   static TextureManager tm;
   return &tm;
}

void TextureManager :: add(const char *path,int id) {
   
   std::map<std::string,int>::iterator it = texIdMap.find(path);
   
   if (it == texIdMap.end()) {
      std::string s = path;
      texIdMap[s] = id;

      //fprintf(stdout,"TextureManager::add() : id = %d\n",id);

   }
}

int TextureManager :: get(const char *path) {
   
   std::map<std::string,int>::iterator it = texIdMap.find(path);
   
   if (it == texIdMap.end()) {
      //fprintf(stdout,"TextureManager::get() : id = -1\n");
      return -1;
   }
   else {
      //fprintf(stdout,"TextureManager::get() : id = %d\n",(*it).second);
      return (*it).second;
   }
   
}