#include <lib3d/model/model.h>
#include <lib3d/util2d/Texture.h>

Model :: Model() {
   setPath("");
}

Model :: ~Model() {

   int i;

   for (i=0;i<materialCount;++i)
      if (materials[i].texture) {
         delete materials[i].texture;
      }
   
   // !!!!!! BUG !!!!!! removing this line causes a runtime memory error!!! why??!!
   //delete[] materials;

   for (i=0;i<meshCount;++i) {
      if (meshes[i].vertices != NULL) delete[] meshes[i].vertices;
      if (meshes[i].normals != NULL)  delete[] meshes[i].normals;
      if (meshes[i].faces != NULL) delete[] meshes[i].faces;
      if (meshes[i].uvs != NULL)  delete[] meshes[i].uvs;
   }

   delete[] meshes;

}

Vector3d Model :: getBoundingBox(int meshnum) {
   return meshes[meshnum].boundingBox;
}

Vector3d Model :: getBoundingBox() {
   return meshes[0].boundingBox;
}

float Model :: getBoundingSphere(int meshnum) {
   return meshes[meshnum].boundingSphereRad;
}

float Model :: getBoundingSphere() {
   return meshes[0].boundingSphereRad;
}

void Model :: build() {
   
   for (int i=0;i<materialCount;++i)
      if (materials[i].texture != NULL)
         if (materials[i].texture->build() == false) {
            delete materials[i].texture;
            materials[i].texture = NULL;
         }

}


void Model :: render() {

   for (int m=0;m<meshCount;++m) {
      
      tMesh *mesh = &meshes[m];
      Texture *texture = NULL;
         
      if (materials != NULL && materialCount > mesh->materialIndex)
         texture = materials[mesh->materialIndex].texture;

      if (texture)
         render_textured(mesh,texture);
      else
         render_untextured(mesh);
         
   }

}

void Model :: render_textured(tMesh *mesh,Texture *texture) const {

   texture->begin();
         
   for (int f=0;f<mesh->faceCount;++f) {
      glBegin(GL_TRIANGLES);
      tFace *ff = &mesh->faces[f];
      for (int i=0;i<3;++i) {
         glNormal3f(mesh->normals[ff->n[i]].x,
                    mesh->normals[ff->n[i]].y,
                    mesh->normals[ff->n[i]].z);
         texture->apply(mesh->uvs[ff->uv[i]].u,mesh->uvs[ff->uv[i]].v);
         glVertex3f(mesh->vertices[ff->v[i]].x,
                    mesh->vertices[ff->v[i]].y,
                    mesh->vertices[ff->v[i]].z);
      }
      glEnd();
   }

   texture->end();

}

void Model :: render_untextured(tMesh *mesh) const {

   for (int f=0;f<mesh->faceCount;++f) {
      glBegin(GL_TRIANGLES);
      tFace *ff = &mesh->faces[f];
      for (int i=0;i<3;++i) {
         glNormal3f(mesh->normals[ff->n[i]].x,
                    mesh->normals[ff->n[i]].y,
                    mesh->normals[ff->n[i]].z);
         glVertex3f(mesh->vertices[ff->v[i]].x,
                    mesh->vertices[ff->v[i]].y,
                    mesh->vertices[ff->v[i]].z);
      }
      glEnd();
   }

}


void Model :: setMeshes(tMesh *meshes,int count) {
   this->meshes = meshes;
   meshCount = count;
}

void Model :: setMaterials(tMaterial *materials,int count) {
   this->materials = materials;
   materialCount = count;
}

void Model :: setPath(const char *path) {
   strcpy(this->path,path);
}

const char* Model :: getPath() {
   return path;
}

