#include <lib3d/model/loader/ObjLoader.h>
#include <vector>

using namespace std;

ObjLoader :: ObjLoader() {
}

ObjLoader :: ~ObjLoader() {
}

ObjLoader* ObjLoader :: instance() {
   static ObjLoader loader;
   return &loader;
}

Model* ObjLoader :: load(char *path) {

   char  line[256];
   char  mtlpath[256] = {0};
   char  texturepath[256] = {0};
   bool  useTexture=false;
   tVertex vertex;
   tUV uv;
   tFace face;
   Vector3d vector;
      
   fp = fopen(path,"rt");
   if (fp == NULL)
      return NULL;
   
   Model *model = new Model();
   tMesh *mesh  = new tMesh;
   strcpy(mesh->name,"obj_mesh");
   std::vector<tVertex> vertexArray;
   std::vector<Vector3d> vectorArray;
   std::vector<tUV> uvArray;
   std::vector<tFace> faceArray;
   
   do {

      readLine(line);
      if (getTokenType(line) == TT_mtllib) {
         sscanf(line,"mtllib %s",mtlpath);
                  
         char ll[256];
         FILE *fpmtl = fopen(mtlpath,"rt");
         if (fpmtl) {
            
            bool loop=true;
            while (loop) {
            
               // readline
               while (fgets(ll,255,fpmtl) != NULL && (strlen(ll) == 1 || ll[0] == '#'));

               char *ptr = strchr(ll,' ');
               int len = ptr - ll;
               if (ll[0] == 0)
                  loop = false;
               else
               if (strncmp(ll,"map_Kd",len) == 0) {
                  sscanf(ll,"map_Kd %s",texturepath);
                  useTexture = true;
                  loop = false;
               }

            }
            fclose(fpmtl);
         }
         
      }

   } while (getTokenType(line) != TT_v);

   mesh->vertexCount = 0;
   do {
      mesh->vertexCount++;
      readVertexData(line,&vertex);
      vertexArray.push_back(vertex);
      readLine(line);
   } while (getTokenType(line) == TT_v);
   
   float maxx=-100000,maxy=-100000,maxz=-100000;
   float minx=100000,miny=100000,minz=100000;
 
   mesh->vertices = new tVertex[mesh->vertexCount];
   for (int i=0;i<mesh->vertexCount;++i) {
      mesh->vertices[i] = vertexArray[i];

      // BoundingBox calculation for mesh
      if (maxx < mesh->vertices[i].x) maxx = mesh->vertices[i].x;
      if (maxy < mesh->vertices[i].y) maxy = mesh->vertices[i].y;
      if (maxz < mesh->vertices[i].z) maxz = mesh->vertices[i].z;
      if (minx > mesh->vertices[i].x) minx = mesh->vertices[i].x;
      if (miny > mesh->vertices[i].y) miny = mesh->vertices[i].y;
      if (minz > mesh->vertices[i].z) minz = mesh->vertices[i].z;

   }
   vertexArray.clear();

   float dx = maxx-minx;
   float dy = maxy-miny;
   float dz = maxz-minz;
   mesh->boundingBox.set(dx,dy,dz);
      
   float maxkoord = dx;
   if (dy > maxkoord) maxkoord = dy;
   if (dz > maxkoord) maxkoord = dz;
   mesh->boundingSphereRad = maxkoord; 

   mesh->uvCount = 0;
   do {
      mesh->uvCount++;
      readTextureData(line,&uv);
      uvArray.push_back(uv);
      readLine(line);
   } while (getTokenType(line) == TT_vt);

   mesh->uvs = new tUV[mesh->uvCount];
   for (i=0;i<mesh->uvCount;++i) {
      mesh->uvs[i] = uvArray[i];
   }
   uvArray.clear();

   mesh->normalCount = 0;
   do {
      mesh->normalCount++;
      readNormalData(line,&vector);
      vectorArray.push_back(vector);
      readLine(line);
   } while (getTokenType(line) == TT_vn);
   
   mesh->normals = new Vector3d[mesh->normalCount];
   for (i=0;i<mesh->normalCount;++i) {
      mesh->normals[i] = vectorArray[i];
   }
   vectorArray.clear();

   while (getTokenType(line) != TT_f) {
      readLine(line);
   }

   mesh->faceCount = 0;
   do {
      mesh->faceCount++;
      readFaceData(line,&face);
      faceArray.push_back(face);
      readLine(line);
   } while (getTokenType(line) == TT_f);

   mesh->faces = new tFace[mesh->faceCount];
   for (i=0;i<mesh->faceCount;++i) {
      mesh->faces[i] = faceArray[i];
      mesh->faces[i].v[0] -= 1;
      mesh->faces[i].v[1] -= 1;
      mesh->faces[i].v[2] -= 1;
      mesh->faces[i].uv[0] -= 1;
      mesh->faces[i].uv[1] -= 1;
      mesh->faces[i].uv[2] -= 1;
      mesh->faces[i].n[0] -= 1;
      mesh->faces[i].n[1] -= 1;
      mesh->faces[i].n[2] -= 1;
   }
   faceArray.clear();
   
   model->setMeshes(mesh,1);
   
   if (!useTexture) {
      model->setMaterials(NULL,0);
      mesh->materialIndex = -1;
   }
   else {
   
      tMaterial *mat = new tMaterial;
      mat->texture = new Texture(texturepath);
      model->setMaterials(mat,1);

      mesh->materialIndex = 0;
   
   }

   fclose(fp);
   return model;
}

void ObjLoader :: skipLine() {
   char tmp[256];
   readLine(tmp);
}

void ObjLoader :: readVertexData(const char *line,tVertex *dest) {
   sscanf(line,"v %f %f %f",&dest->x,&dest->y,&dest->z);
}

void ObjLoader :: readTextureData(const char *line,tUV *uv) {
   sscanf(line,"vt %f %f",&uv->u,&uv->v);
}

void ObjLoader :: readNormalData(const char *line,Vector3d *vec) {
   sscanf(line,"vn %f %f %f",&vec->x,&vec->y,&vec->z);
}

void ObjLoader :: readFaceData(const char *line,tFace *dest) {
   sscanf(line,"f %d/%d/%d %d/%d/%d %d/%d/%d",&dest->v[0],&dest->uv[0],&dest->n[0],
      &dest->v[1],&dest->uv[1],&dest->n[1],&dest->v[2],&dest->uv[2],&dest->n[2]);
}

void ObjLoader :: readLine(char *line) {

   // bos satirlari ve aciklama satirlarini atla... (# ile baslayanlar aciklamadir..)
   // ilk bulunann satiri line icinde geri getir..

   while (fgets(line,255,fp) != NULL && 
      (strlen(line) == 1 || line[0] == '#'));

   if (feof(fp))
      line[0] = '\0';

}

ObjLoader::TokenType ObjLoader :: getTokenType(const char *line) {

   char *ptr = strchr(line,' ');
   int len = ptr - line;

   if (strncmp(line,"v",len) == 0)
      return TT_v;
   else
   if (strncmp(line,"vn",len) == 0)
      return TT_vn;
   else
   if (strncmp(line,"vt",len) == 0)
      return TT_vt;
   else
   if (strncmp(line,"f",len) == 0)
      return TT_f;
   else
   if (strncmp(line,"o",len) == 0)
      return TT_o;
   else
   if (strncmp(line,"s",len) == 0)
      return TT_s;
   else
   if (strncmp(line,"usemtl",len) == 0)
      return TT_usemtl;
   else
   if (strncmp(line,"mtllib",len) == 0)
      return TT_mtllib;

   return TT_notvalid;
}

