#include <lib3d/model/loader/_3dsloader.h>

_3DSLoader :: _3DSLoader() {
}

_3DSLoader :: ~_3DSLoader() {
}

_3DSLoader* _3DSLoader :: instance() {
   static _3DSLoader *loader = new _3DSLoader;
   return loader;
}

Model* _3DSLoader :: load(char *path) {
  
   const char *camera;
   
   file = lib3ds_file_load(path);

   if (!file) {
      fprintf(stderr,"_3DSLoader::load() :: Loading 3DS file failed\n");
      exit(-1);
   }
   
   /*
   if (!file->cameras) {
      fprintf(stderr,"_3DSLoader::load() :: Loading 3DS file failed (no camera found!)\n");
      lib3ds_file_free(file);
      exit(-1);
   }
   */

   camera = file->cameras->name;
   lib3ds_file_eval(file,0);   

   vector<tMesh*> meshes;
   Lib3dsNode *p;

   for (p = file->nodes;p!=NULL;p = p->next) {
      tMesh *m = processNode(p);
      if (m)
         meshes.push_back(m);
   }

   tMesh *meshArray = new tMesh[meshes.size()];
   for (int i=0;i<meshes.size();++i)
      meshArray[i] = *meshes[i];
   
   Model *model = new Model;
   model->setMeshes(meshArray,meshes.size());
   model->setMaterials(NULL,0);
   
   lib3ds_file_free(file);
   return model;
}

tMesh* _3DSLoader :: processNode(Lib3dsNode *node) {

   Lib3dsNode *p;
   for (p = node->childs;p!=NULL;p = p->next) {
      processNode(p);
   }

   if (node->type == LIB3DS_OBJECT_NODE) {

      Lib3dsMesh *m = lib3ds_file_mesh_by_name(file,node->name);
      assert(m);
      if (!m)
         return NULL;

      tMesh *mesh = new tMesh;
      mesh->faceCount   = m->faces;
      mesh->vertexCount = m->points;
      mesh->uvCount     = m->texels;
      mesh->normalCount = m->faces * 3;
      mesh->vertices    = new tVertex[mesh->vertexCount];
      mesh->faces       = new tFace[mesh->faceCount];
      mesh->uvs         = new tUV[mesh->uvCount];
      mesh->normals     = new Vector3d[mesh->normalCount];
      mesh->materialIndex = -1;

      Lib3dsVector *normalL = new Lib3dsVector [3 * m->faces];
      lib3ds_mesh_calculate_normals(m, normalL);

      for (int i=0;i<m->faces;++i) {
         mesh->normals[i].set(normalL[i][0],normalL[i][1],normalL[i][2]);
      }

      for (i=0;i<m->points;++i) {
         mesh->vertices[i].x = m->pointL[i].pos[0];
         mesh->vertices[i].y = m->pointL[i].pos[1];
         mesh->vertices[i].z = m->pointL[i].pos[2];
      }

      for (i=0;i<m->texels;++i) {
         mesh->uvs[i].u = m->texelL[i][0];
         mesh->uvs[i].v = m->texelL[i][1];
      }

      for (i=0;i<m->faces;++i) {
         mesh->faces[i].v[0]  = m->faceL[i].points[0];
         mesh->faces[i].v[1]  = m->faceL[i].points[1];
         mesh->faces[i].v[2]  = m->faceL[i].points[2];
         mesh->faces[i].n[0]  = i * 3;
         mesh->faces[i].n[1]  = i * 3 + 1;
         mesh->faces[i].n[2]  = i * 3 + 2;
         mesh->faces[i].uv[0] = i * 3;
         mesh->faces[i].uv[1] = i * 3 + 1;
         mesh->faces[i].uv[2] = i * 3 + 2;
      }

      delete []normalL;
      return mesh;
   }
   
   return NULL;
}

