#include <lib3d/lib3d.h>

PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB = NULL;
PFNGLACTIVETEXTUREARBPROC   glActiveTextureARB   = NULL;
PFNGLFOGCOORDFEXTPROC       glFogCoordfEXT       = NULL; 
PFNGLCLIENTACTIVETEXTUREARBPROC glClientActiveTextureARB = NULL;

void initLib3d(bool initForWin32) {

   if (initForWin32) {
      if (!glActiveTextureARB)
         glActiveTextureARB	= (PFNGLACTIVETEXTUREARBPROC)    wglGetProcAddress("glActiveTextureARB");

      if (!glMultiTexCoord2fARB)
         glMultiTexCoord2fARB	= (PFNGLMULTITEXCOORD2FARBPROC)  wglGetProcAddress("glMultiTexCoord2fARB");

      if (!glFogCoordfEXT)
         glFogCoordfEXT       = (PFNGLFOGCOORDFEXTPROC)        wglGetProcAddress("glFogCoordfEXT");
      
      if (!glClientActiveTextureARB)
         glClientActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC) wglGetProcAddress("glClientActiveTextureARB");
   }
   else {
      if (!glActiveTextureARB)
         glActiveTextureARB	= (PFNGLACTIVETEXTUREARBPROC)   SDL_GL_GetProcAddress("glActiveTextureARB");

      if (!glMultiTexCoord2fARB)
         glMultiTexCoord2fARB	= (PFNGLMULTITEXCOORD2FARBPROC) SDL_GL_GetProcAddress("glMultiTexCoord2fARB");

      if (!glFogCoordfEXT)
         glFogCoordfEXT       = (PFNGLFOGCOORDFEXTPROC)       SDL_GL_GetProcAddress("glFogCoordfEXT");

      if (!glClientActiveTextureARB)
         glClientActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC) SDL_GL_GetProcAddress("glClientActiveTextureARB");
   }

   if(!glActiveTextureARB || !glMultiTexCoord2fARB) {
      fprintf(stderr,"initLib3d() :: ERROR :: multitexturing not supported!");
      exit(-1);
   }

   if(!glFogCoordfEXT) {
      fprintf(stderr,"initLib3d() :: ERROR :: glFogCoordf not supported");
      exit(-1);
   }


}