#ifndef __QUATERNION_H__
#define __QUATERNION_H__

#include <lib3d/util3d/vector3d.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

class Quaternion {

public:

   Quaternion();
   Quaternion(Quaternion *q1,Quaternion *q2,float interpolation);
   Quaternion(float x,float y,float z,float w);
   ~Quaternion();

   void  set(Quaternion *q);
   void  set(float x,float y,float z,float w);
   void  reset();
   float magnitude();
   void  normalize();
   void  invert();
   void  createFromAxisAngle(Vector3d *axis,float angle);
   void  createFromAxisAngle(float x,float y,float z,float angle);
   void  slerp(Quaternion *q1,Quaternion *q2,float interpolation);
   void  createMatrix(float *mat);

   float x,y,z,w;

};


#endif