
#include "mosresim.h"


MOSResim::MOSResim(void)
{

}
MOSResim::~MOSResim(void)
{

}

bool MOSResim::TextureYap(UINT &texture, LPSTR strFileName)
{
	AUX_RGBImageRec *pImage = NULL;
	FILE *pFile = NULL;

//	CHAR print[200];

	if(!strFileName) 
		return false;

	// Open a file pointer to the BMP file and check if it was found and opened 
	if((pFile = fopen(strFileName, "rb")) == NULL) 
	{
		// Display an error message saying the file was not found, then return NULL
		MessageBox(g_hWnd, "Texture bulunamadi.Bitmap acilamadi!", "Hata", MB_OK);
//		sprintf(print,"|-----> %s dosyasi bulunamadi!",strFileName);
//		g_log.bPrint(print);
		return NULL;
	}

//	g_log.bPrint("|");
//	g_log.bPrint(strFileName);
	// Load the bitmap using the aux function stored in glaux.lib
	pImage = auxDIBImageLoad(strFileName);				

	// Make sure valid image data was given to pImage, otherwise return false
	if(pImage == NULL)								
		return false;

	// Generate a texture with the associative texture ID stored in the array
	glGenTextures(1, &texture);

	// This sets the alignment requirements for the start of each pixel row in memory.
	glPixelStorei (GL_UNPACK_ALIGNMENT, 1);

	// Bind the texture to the texture arrays index and init the texture
	glBindTexture(GL_TEXTURE_2D, texture);
	
	// Build Mipmaps (builds different versions of the picture for distances - looks better)
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, pImage->sizeX, 
					  pImage->sizeY, GL_RGB, GL_UNSIGNED_BYTE, pImage->data);

	//Assign the mip map levels and texture info
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	// Now we need to free the image data that we loaded since openGL stored it as a texture

//	sprintf(print,"|-----> %s dosyasi yuklendi...",strFileName);
//	g_log.bPrint(print);

	if (pImage)										// If we loaded the image
	{
		if (pImage->data)							// If there is texture data
		{
			free(pImage->data);						// Free the texture data, we don't need it anymore
		}

		free(pImage);								// Free the image structure
	}

	// Return a success
	return true;
}
bool MOSResim::TextureYapPack(UINT &texture, LPSTR strFileName)
{



	AUX_RGBImageRec *pImage = NULL;
	FILE *pFile = NULL;
	CDXPacker pack;


//	CHAR print[200];

	if(!strFileName) 
		return false;
	
	//Packi ac
	char bmpname[200]={0};
	char packname[200]={0};

/*
	strcat(strJPGPath, "\\");
	strcat(strJPGPath, strFileName);
	strcpy(strTGAPath, strJPGPath);
	*/
	strcpy(bmpname,"");
	strcpy(packname,"");
	strcat(bmpname,strFileName);
	strcat(packname,strFileName);
	strcat( bmpname, ".bmp" );
	strcat( packname, ".spr");


	pack.ExpandToFile(packname,bmpname);

	// Open a file pointer to the BMP file and check if it was found and opened 
	if((pFile = fopen(bmpname, "rb")) == NULL) 
	{
		// Display an error message saying the file was not found, then return NULL
	//	MessageBox(g_hWnd, "Texture bulunamadi.Bitmap acilamadi!", "Hata", MB_OK);
	//	sprintf(print,"|-----> %s dosyasi bulunamadi!",packname);
	//	g_log.bPrint(print);
		return NULL;
	}

//	g_log.bPrint("|");
//	g_log.bPrint(strFileName);
	// Load the bitmap using the aux function stored in glaux.lib
	pImage = auxDIBImageLoad(bmpname);				

	// Make sure valid image data was given to pImage, otherwise return false
	if(pImage == NULL)								
		return false;

	// Generate a texture with the associative texture ID stored in the array
	glGenTextures(1, &texture);

	// This sets the alignment requirements for the start of each pixel row in memory.
	glPixelStorei (GL_UNPACK_ALIGNMENT, 1);

	// Bind the texture to the texture arrays index and init the texture
	glBindTexture(GL_TEXTURE_2D, texture);
	
	// Build Mipmaps (builds different versions of the picture for distances - looks better)
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, pImage->sizeX, 
					  pImage->sizeY, GL_RGB, GL_UNSIGNED_BYTE, pImage->data);

	//Assign the mip map levels and texture info
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	// Now we need to free the image data that we loaded since openGL stored it as a texture

//	sprintf(print,"|-----> %s dosyasi yuklendi...",packname);
//	g_log.bPrint(print);

	if (pImage)										// If we loaded the image
	{
		if (pImage->data)							// If there is texture data
		{
			free(pImage->data);						// Free the texture data, we don't need it anymore
		}

		free(pImage);								// Free the image structure
	}

	// Return a success
	return true;
}
int MOSResim::EkranGoruntusu()
{
  // we will store the image data here
  uchar *pixels;
  // the thingy we use to write files
  FILE * shot;
  // we get the width/height of the screen into this array
  int screenStats[4];

  // get the width/height of the window
  glGetIntegerv(GL_VIEWPORT, screenStats);

  // generate an array large enough to hold the pixel data 
  // (width*height*bytesPerPixel)
  pixels = new unsigned char[screenStats[2]*screenStats[3]*3];
  // read in the pixel data, TGA's pixels are BGR aligned
  glReadPixels(0, 0, screenStats[2], screenStats[3], GL_BGR_EXT, 
                                   GL_UNSIGNED_BYTE, pixels);

  // open the file for writing. If unsucessful, return 1
  if((shot=fopen("ekrang.tga", "wb"))==NULL) return 1;

  // this is the tga header it must be in the beginning of 
  // every (uncompressed) .tga
  uchar TGAheader[12]={0,0,2,0,0,0,0,0,0,0,0,0};
  // the header that is used to get the dimensions of the .tga
  // header[1]*256+header[0] - width
  // header[3]*256+header[2] - height
  // header[4] - bits per pixel
  // header[5] - ?
  uchar header[6]={((int)(screenStats[2]%256)),
                   ((int)(screenStats[2]/256)),
                   ((int)(screenStats[3]%256)),
		   ((int)(screenStats[3]/256)),24,0};

  // write out the TGA header
  fwrite(TGAheader, sizeof(uchar), 12, shot);
  // write out the header
  fwrite(header, sizeof(uchar), 6, shot);
  // write the pixels
  fwrite(pixels, sizeof(uchar), 
                 screenStats[2]*screenStats[3]*3, shot);

  // close the file
  fclose(shot);
  // free the memory
  delete [] pixels;

  // return success
  return 0;
}

