//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Audio.h"


//Oyunda kullanilacak ses dosyalari teker teker burada ekleniyor.
void Audio::setAudioFiles(int i,char* fileName){
	
    ++audioCounter;
    file[i-1]=fileName;

}


//Eklenmis olan tm ses dosyalarinin tanimlanma islemleri yapiliyor.
bool Audio::initializeAudios (){
	
    //Ses dosyasnn pozisyon ve yer bilgisi
    ALfloat sourcePosition[] = {0.0f, 0.0f, 0.0f};
    ALfloat sourceVelocity[] = {0.0f, 0.0f, 0.0f};

    ALfloat listenerPosition[] = {0.0f, 0.0f, 0.0f};
    ALfloat listenerVelocity[] = {0.0f, 0.0f, 0.0f};

    ALfloat listenerOrientation[] = {0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};

    alutInit(NULL, 0);
    if(alGetError() != AL_NO_ERROR)
        return false;
	
    alGenBuffers(audioCounter, soundBuffer);
    if(alGetError() != AL_NO_ERROR)
        return false;

    for (int i=0;i<audioCounter;++i){
        alutLoadWAVFile(file[i], &format, &data, &size, &frequency, &loop);
        alBufferData(soundBuffer[i], format, data, size, frequency);
        alutUnloadWAV(format, data, size, frequency);
    }

    alGenSources(audioCounter, source);
    if(alGetError() != AL_NO_ERROR)
        return false;
	
    for (i=0;i<audioCounter;++i){	
        alSourcei (source[i], AL_BUFFER, soundBuffer[i]);
        alSourcei (source[i], AL_LOOPING, false);
        alSourcef (source[i], AL_GAIN, 0.7f);
        alSourcef (source[i], AL_PITCH, 1.0f);
        alSourcefv(source[i], AL_POSITION, sourcePosition);
        alSourcefv(source[i], AL_VELOCITY, sourceVelocity);
    }
	
    alListenerfv(AL_POSITION, listenerPosition);
    alListenerfv(AL_VELOCITY, listenerVelocity);
    alListenerfv(AL_ORIENTATION, listenerOrientation);
	
    return true;
}

void Audio::Play(int i){
    alSourcePlay(source[i-1]);
} 
void Audio::Stop(int i){
    alSourceStop(source[i-1]);   
}

Audio::~Audio(){
    alutExit();
}