//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Texture.h"

std::map<std::string,unsigned int> textureTable;

AUX_RGBImageRec *LoadBMP(char *Filename)
{
	FILE *File=NULL;
	
	if (!Filename){
        return NULL;
	}
	
    File=fopen(Filename,"r");
	
    if (File){
        fclose(File);
        return auxDIBImageLoad(Filename);
    }
	
    return NULL;
}

//Texture yklerken alpha degiskeni true oldugunda alpha kanali ykleniyor.
unsigned int LoadGLTextures(char *FileName,bool alpha){

    std::map<std::string,unsigned int>::iterator it = textureTable.find(FileName);
    if (it != textureTable.end()) {
        return (*it).second;
    }
	
    int Status=FALSE;
    AUX_RGBImageRec *TextureImage[1];
    unsigned int texture_id = 0;
	
    memset(TextureImage,0,sizeof(void *)*1);

    if (TextureImage[0]){
        if (TextureImage[0]->data){
            free(TextureImage[0]->data);
        }
        free(TextureImage[0]);
    }	
	
    // Bitmap dosya ykleniyor.
    if (TextureImage[0]=LoadBMP(FileName)){
        Status=TRUE;

        glGenTextures(1, &texture_id);

        glBindTexture(GL_TEXTURE_2D, texture_id);
		
        if (alpha){

            unsigned char *buffer = new unsigned char[TextureImage[0]->sizeX*TextureImage[0]->sizeY*4];
			
			
            for (int i=0;i<TextureImage[0]->sizeX*TextureImage[0]->sizeY;++i) {
			
                buffer[i*4] = TextureImage[0]->data[i*3];
                buffer[i*4+1] = TextureImage[0]->data[i*3+1];
                buffer[i*4+2] = TextureImage[0]->data[i*3+2];
				
                if (TextureImage[0]->data[i*3] == 0 || TextureImage[0]->data[i*3+1] == 0 || TextureImage[0]->data[i*3+2] == 0)
                    buffer[i*4+3] = 0;
                else
                    buffer[i*4+3] = 255;
			
            }
						
            glTexImage2D(GL_TEXTURE_2D, 0, 4, TextureImage[0]->sizeX, TextureImage[0]->sizeY, 0, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
        }
        else{
            glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[0]->sizeX, TextureImage[0]->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[0]->data);				
        }				
		
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	
		
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);	
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);	
    }

    if (TextureImage[0]){
        if (TextureImage[0]->data){
            free(TextureImage[0]->data);
        }
        free(TextureImage[0]);
    }

    textureTable.insert(std::map<std::string,unsigned int>::value_type(FileName,texture_id));

    return texture_id;
}