//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Screen.h"

Screen::Screen(unsigned int backTex,unsigned int borderText,SecondaryWeapon *secondaryWeapon){
    
    healthTexture = LoadGLTextures("TextureFiles\\skull.bmp",false);	
    oilTexture = LoadGLTextures("TextureFiles\\fallout.bmp",false);	
	
    backTexture = backTex;
    borderTexture = borderText;
       
    this->secondaryWeapon = secondaryWeapon;          

}

void Screen::RenderScreenBackground(){
	
    //Arka resim ciziliyor
    glNormal3f(0.0f,0.0f,1.0f);	
    glColor3f(1.0f,1.0f,1.0f);
	
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);	
	
    glMatrixMode(GL_TEXTURE);
    glBindTexture(GL_TEXTURE_2D, backTexture);
    glEnable(GL_TEXTURE_2D);	
    glLoadIdentity();		
	
    glPushMatrix();	
    glBegin(GL_QUADS);
        glTexCoord2f(0,1); glVertex3f(-40.0f,30.0f,-10.0f);
        glTexCoord2f(0,0); glVertex3f(-40.0f,-30.0f,-10.0f);					
        glTexCoord2f(1,0); glVertex3f(40.0f, -30.0f,-10.0f);			
        glTexCoord2f(1,1); glVertex3f(40.0f, 30.0f,-10.0f);					
    glEnd();
	
    glPopMatrix();
	
    glMatrixMode(GL_MODELVIEW);		
}

void Screen::RenderScreenFrame(int deathCounter,float Velocity){
    
    static float counter=0;
    counter += Velocity;
    
    glColor3f(0.0f,0.0f,0.0f);  

    //Bilgi Paneli iziliyor
    glDisable(GL_BLEND);
    
    glBindTexture(GL_TEXTURE_2D, borderTexture);
    glEnable(GL_TEXTURE_2D);
    glColor3f(1.0f,1.0f,1.0f);  
    glBegin(GL_QUADS);
        glTexCoord2f(0.0f,1.0f); glVertex3f(MIN_X-1.0f,MIN_Y+1.0f,1.0f);
        glTexCoord2f(0.0f,0.0f); glVertex3f(MIN_X-1.0f,MIN_Y-4.0f,1.0f);					
        glTexCoord2f(1.0f,0.0f); glVertex3f(MAX_X+1.0f,MIN_Y-4.0f,1.0f);			
        glTexCoord2f(1.0f,1.0f); glVertex3f(MAX_X+1.0f,MIN_Y+1.0f,1.0f);					
    glEnd();
    
    
    for (int i=0;i<SECONDARY_WEAPON_COUNT;++i){
        glBindTexture(GL_TEXTURE_2D, secondaryWeapon[i].texture);

        if (secondaryWeapon[i].active){
            float color = fabs(sin(counter*10));
            glColor3f(color,color,color);
        }
        
        if (secondaryWeapon[i].counter <= 0 )
            glColor3f(0.4f,0.4f,0.4f);
        
        glBegin(GL_QUADS);
            glTexCoord2f(0.0f,1.0f); glVertex3f(MIN_X+1.0f + (i * 6),MIN_Y-0.5f,-0.1f);
            glTexCoord2f(0.0f,0.0f); glVertex3f(MIN_X+1.0f + (i * 6),MIN_Y-3.0f,-0.1f);					
            glTexCoord2f(1.0f,0.0f); glVertex3f(MIN_X+3.5f + (i * 6),MIN_Y-3.0f,-0.1f);			
            glTexCoord2f(1.0f,1.0f); glVertex3f(MIN_X+3.5f + (i * 6),MIN_Y-0.5f,-0.1f);					
        glEnd();

        glColor3f(1.0f,1.0f,1.0f);
    } 

    //------------------------
    glBindTexture(GL_TEXTURE_2D, healthTexture);
    glBegin(GL_QUADS);
        glTexCoord2f(0.0f,1.0f); glVertex3f(MAX_X-1.5f,MIN_Y-2.0f,-0.1f);
        glTexCoord2f(0.0f,0.0f); glVertex3f(MAX_X-1.5f,MIN_Y-3.5f,-0.1f);					
        glTexCoord2f(1.0f,0.0f); glVertex3f(MAX_X,MIN_Y-3.5f,-0.1f);			
        glTexCoord2f(1.0f,1.0f); glVertex3f(MAX_X,MIN_Y-2.0f,-0.1f);					
    glEnd();
	
    glBindTexture(GL_TEXTURE_2D, oilTexture);
    glBegin(GL_QUADS);
        glTexCoord2f(0.0f,1.0f); glVertex3f(MAX_X-1.5f,MIN_Y+0.0f,-0.1f);
        glTexCoord2f(0.0f,0.0f); glVertex3f(MAX_X-1.5f,MIN_Y-1.5f,-0.1f);					
        glTexCoord2f(1.0f,0.0f); glVertex3f(MAX_X-0.0f,MIN_Y-1.5f,-0.1f);			
        glTexCoord2f(1.0f,1.0f); glVertex3f(MAX_X-0.0f,MIN_Y+0.0f,-0.1f);					
    glEnd();
	 	
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_BLEND);   

    glPopMatrix();

}