//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/

#include <list>
#include <math.h>
#include <string.h>

#include "Framework.h"
#include "Vector.h"

#include "Screen.h"
#include "Sky.h"
#include "Ship.h"

#include "Meteor.h"
#include "EnemyDummy.h"
#include "EnemyNormal.h"
#include "EnemySmart.h"

#include "EnemyFire.h"
#include "Fire.h"
#include "Bonus.h"

#include "Font.h"
#include "Audio.h"

#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795
#endif 

typedef	std::list <Meteor*>     MeteorList;
typedef	std::list <Enemy*>      EnemyList;
typedef	std::list <Fire*>       FireList;
typedef	std::list <EnemyFire*>  EnemyFireList;
typedef	std::list <Bonus*>      WeaponBonusList;

MeteorList      meteorList;
EnemyList       enemyList;
FireList        fireList;
EnemyFireList   enemyFireList;
WeaponBonusList weaponBonusList;

Screen  *screen;
Sky     *sky;
Ship    *ship;

Bonus   *bonus[10];

int     point;
int     fireCounter=0,bonusCounter=0;
int     maxMeteorBonus=10,maxBonus=10,maxEnemy=5,maxMeteor=100;

GLFONT  font;

//Oyun ierisinde kullanilacak olan tm sesler burada tutulacak
Audio   *audios;

//bilgisayar hzn hesaplamak iin gerekli deikenler
long    oldTime = 0;
float   deltaTime=0;
float   playingTime=0,lastPlayingTime=0;
	
//Sahnede gsterilen meteor sayisi.Baslangic icin 10.
int     meteorInTheScene=10;

//patlayan nesne iin patlama noktasnda grntlenecek efekt iin gerekli yapi
struct ExplosionInfo{
	int     explosionType; //1 = meteor explosion, 2 = enemy explosion
	int     explosionSpriteCounter;
	float   explosionSecond;
	Vec3d   explosionPosition;	
};

typedef	std::list <ExplosionInfo*>	ExplosionInfoList;

ExplosionInfoList explosionInfoList;

float   shipExplosionSecond=0;
int     shipExplosionSpriteCounter=0;
bool    shipExplode=false;

//tu basimini kontrol iin gerekli degikenler
bool    lkey=false,rkey=false,ukey=false,dkey=false;
bool    enterKey=false,escKey=false;

//menude hangi numaray secti
int     menuKey=0;

//bonuslarin zamana gre gelip gelmemesi gerektigini kontrol eden degiskenler
struct BonusCome{
	bool    come;
	bool    passive;
	int     type;
	Meteor  *bonusMeteor;
};
BonusCome   bonusCome[10];

enumWeaponType  activeWeapon = (enumWeaponType) -1;
enumWeaponType  firstSecondaryWeapon = DOUBLE_FIRE;
enumWeaponType  lastSecondaryWeapon  = CIRCLE_FIRE;

SecondaryWeapon secondaryWeapon[SECONDARY_WEAPON_COUNT];
int weaponBonusCounter=0;

//TEXTURELAR
unsigned int expText,shipTex,fireTex,enemyFireText,bonusOilTexture,bonusHealthTexture;
unsigned int screen1,back1,splash,finText,congText,pauseText;
unsigned int menuStartActive,menuStartPassive,menuControlsActive,menuControlsPassive,menuExitActive,menuExitPassive;
unsigned int secondaryWeaponFireText ,borderText;

//Enemy texturelari
unsigned int enemy1,enemy2,enemy3;

//Gk taslarinin anime spritelarinin texture numaralarini ieren dizi
unsigned int meteorSprite1[32];	
unsigned int meteorSprite2[32];	
unsigned int meteorSprite3[32];	

//Bonuslarin anime spritelarinin texture numaralarini ieren dizi
unsigned int oilBonusSprite[11];	
unsigned int healthBonusSprite[11];	

void CreateMeteor();
void CreateEnemy();

/*---------------------------------------------------------------------------------
----------------------------------------------------------------------------------*/
void ComputeComputerVelocity(bool pause){
	
	// render isleminden bu yana gecen sure (delta -milisaniye-)	
	long  now = SDL_GetTicks();	
		
	if (!pause){
        deltaTime  = (float) (now - oldTime) / 1000.0f;		
        oldTime  = now;
	}
	else{
        oldTime= now - deltaTime;		
	}
	
}

//iki playing time arasindaki zaman belirli bir miktara gelince ekranda grnen dsman sayisi artiriliyor
void ComputeMeteorInTheScene(float playingTime){
	
    if ( meteorInTheScene<100 ){
        if (playingTime - lastPlayingTime > 1){
            ++meteorInTheScene ;
            CreateMeteor();
            lastPlayingTime=playingTime;
		}
	}  
   
}

void CreateEnemyFire(Enemy *e){
	
    EnemyFire	*ef;
	
    e->configureFireRotation();
    e->setShipPosition(ship->position);	
	
    ef = new EnemyFire(enemyFireText,e->position);
    ef->setFireRotation (e->fireIncX ,e->fireIncY) ;	
    enemyFireList.push_back(ef);
	
}

void CreateEnemy(){

    int a = rand()%3;
	
    Enemy *e;

    switch (a){
	
        case 0: 
            e = new EnemyDummy(2);
            e->setEnemyTextures(enemy1,expText);
            enemyList.push_back(e);		
            break;
        case 1: 
            e = new EnemyNormal(3);
            e->setEnemyTextures(enemy2,expText);
            enemyList.push_back(e);
            break;
        case 2: 
            e = new EnemySmart(2.5);
            e->setEnemyTextures(enemy3,expText);
            enemyList.push_back(e);	
            break;
    }

}
void CreateMeteor(){
   
    Meteor *m=new Meteor();
    m->setMeteorBonus(false); 
	
    switch (m->shape){
        case 0:
            m->setMeteorSprites(meteorSprite1,32);
            break;
        case 1:
            m->setMeteorSprites(meteorSprite2,32);
            break;
        case 2:
            m->setMeteorSprites(meteorSprite3,32);
            break;
    }
    meteorList.push_back(m);

}

void CreateWeaponBonus(){

    if ( point > WEAPON_BONUS_CREATION_POINT * weaponBonusCounter){

        //pozisyonu retiliyor
	    Vec3d position;

        position.x =fabs((sin(rand()) * (MAX_X-1))) + 40 ; 
        position.y =(sin(rand()) * (MAX_Y-3));  
        position.z = 0;

        Bonus *b = new Bonus(position);
	    
         switch  (weaponBonusCounter % 4){
            case DOUBLE_FIRE:
                b->setBonusAsDoubleWeapon();
                b->setBonusSprites (&secondaryWeapon[0].texture,1);
                break;

            case TRIPLE_FIRE:
                b->setBonusAsTripleWeapon();
                b->setBonusSprites (&secondaryWeapon[1].texture,1);
                break;
            
            case DEATH_LINE_FIRE:
                b->setBonusAsDeathLineWeapon();
                b->setBonusSprites (&secondaryWeapon[2].texture,1);
                break;
            
            case CIRCLE_FIRE:
                b->setBonusAsCircleWeapon();
                b->setBonusSprites (&secondaryWeapon[3].texture,1);
                break;

        }       
        
        weaponBonusList.push_back(b);
        ++weaponBonusCounter;
    
    }

}

void SetActiveSecondaryWeapon(){
    
    if (activeWeapon != -1) {
        
        enumWeaponType nextWeapon = (enumWeaponType) ((int) activeWeapon + 1);
        while (true) {
        
            if (nextWeapon > lastSecondaryWeapon)
                nextWeapon = firstSecondaryWeapon;

            if (nextWeapon == activeWeapon){
                if (secondaryWeapon[activeWeapon].counter <=0 )
                    activeWeapon = (enumWeaponType)-1;
                break;
            }
            
            if (secondaryWeapon[nextWeapon].counter > 0) {
                secondaryWeapon[activeWeapon].active = false;
                activeWeapon = nextWeapon;
                secondaryWeapon[activeWeapon].active = true;
                break;
            }

            nextWeapon = (enumWeaponType) ((int) nextWeapon + 1);        
        }

    }
    
}

/*----------------------------------------------------------------------------------
----------------				ARPIMA KONTROLLER				----------------
----------------------------------------------------------------------------------*/
void FireMeteorCollision(){
	
    double dist;	
    bool controlFirePtr=false;

    FireList::iterator fireIterator = fireList.begin();
   
    while (fireIterator != fireList.end()) {
		
        Fire *firePtr = *fireIterator;
		
        MeteorList::iterator meteorIterator = meteorList.begin();	
        while (meteorIterator != meteorList.end()) {			
	
            Meteor	*meteorPtr = *meteorIterator;
			
            dist = sqrt((firePtr->position.x - meteorPtr->position.x) * (firePtr->position.x - meteorPtr->position.x)+
                    (firePtr->position.y - meteorPtr->position.y) * (firePtr->position.y - meteorPtr->position.y));
				
            //carpma olmas durumu
            if (dist <= (meteorPtr->boundingSphereRadius/2)){
 				
                
                if (firePtr->type != DEATH_LINE_FIRE ){
                    //fire siliniyor				
                    FireList::iterator fireCurrent = fireIterator;
                    controlFirePtr = true;
                    ++fireIterator;
                    fireList.erase(fireCurrent);
                    delete firePtr;
                    firePtr = NULL;
                }
            
				
                ExplosionInfo *expInfo = new ExplosionInfo();
				
                expInfo->explosionType			= 1;
                expInfo->explosionPosition		= meteorPtr->position;
                expInfo->explosionSecond		= 0;
                expInfo->explosionSpriteCounter = 0;
				
                explosionInfoList.push_back(expInfo);

                //meteor vurulduu iin zelliklerini yeniliyoruz
                meteorPtr->setObjectProperties();
                point+=5;
				
                audios->Play(2);            
            
                break;            

			}			

            ++meteorIterator;
			
        }

        if ( !controlFirePtr )	++fireIterator;

        controlFirePtr = false;

    }

}

void FireBonusMeteorCollision(){
	
    double dist;
    bool controlFirePtr=false;

    FireList::iterator fireIterator = fireList.begin();

    while (fireIterator != fireList.end()) {		
		
        Fire *firePtr = *fireIterator;
	
        for (int j=0; j<maxMeteorBonus ; ++j){
            if (bonusCome[j].bonusMeteor != NULL){
                dist = sqrt((firePtr->position.x - bonusCome[j].bonusMeteor->position.x) * (firePtr->position.x - bonusCome[j].bonusMeteor->position.x)+
                            (firePtr->position.y - bonusCome[j].bonusMeteor->position.y) * (firePtr->position.y - bonusCome[j].bonusMeteor->position.y));
				
                //carpma olmas durumu
                if (dist <= (bonusCome[j].bonusMeteor->boundingSphereRadius/2)){
					
                    if (firePtr->type != DEATH_LINE_FIRE ){
                        //fire siliniyor				
                        FireList::iterator fireCurrent = fireIterator;
                        controlFirePtr = true;
                        ++fireIterator;
                        fireList.erase(fireCurrent);
                        delete firePtr;
                        firePtr = NULL;
                    }
            
               
                    //ierisinde bonus olan bir meteor vurulduu iin 
				    //iindeki bonus yaratlyor
					
                    Bonus *b = new Bonus(bonusCome[j].bonusMeteor->position);
					
				    if (bonusCome[j].type==OIL_BONUS){
                        b->setBonusAsOil();
                        b->setBonusSprites (oilBonusSprite,11);
                    }
                    else if (bonusCome[j].type==HEALTH_BONUS){
                        b->setBonusAsHealth();
                        b->setBonusSprites (healthBonusSprite,11);
                    }
					
                    bonus[bonusCounter] = b;
                    ++bonusCounter;
					
                    bonusCome[j].come=false;
                    bonusCome[j].passive=false;
					
                    //Bonus olan meteor vuruldu ve iinden bir bonus ikti bundan dolayi 
                    //yeni kullanim iin bonusCome yapisi ierigini yenileyip yeni bonuslu Meteori hazirliyoruz.
                    //Yeniden ihtiya olunca gnderebilmek iin.
                    for (int k=0;k<maxMeteorBonus;++k){
                        if (bonusCome[k].type==bonusCome[j].type){
                            bonusCome[k].come=false;
                            bonusCome[k].bonusMeteor->setObjectProperties();
                        }
                    }

                    break;
                }

										
            }

        }
		
        if ( !controlFirePtr ) ++fireIterator;
        controlFirePtr = false;				
    
    }
	
}

void ShipMeteorCollision(){

    int j=0;
    double dist;
    bool  controlCollision=false;

    MeteorList::iterator meteorIterator = meteorList.begin();
	
    while (meteorIterator != meteorList.end()) {
		
        Meteor  *meteorPtr = *meteorIterator;

        //Bonusu olmayan meteorler ile arpma kontrolu
        dist = sqrt((ship->position.x - meteorPtr->position.x) * (ship->position.x - meteorPtr->position.x)+
                    (ship->position.y - meteorPtr->position.y) * (ship->position.y - meteorPtr->position.y));
		
        //carpma olmas durumu
        if (dist < (meteorPtr->boundingSphereRadius/2) + (ship->shipHeight/3)){

            meteorPtr->setObjectProperties();
            point-=2;

            shipExplode = true;
            shipExplosionSecond = 0;
            shipExplosionSpriteCounter = 0;
            ++ship->damage;
            audios->Play(3);
        
        }

        ++meteorIterator;
    
    }

}

void ShipBonusMeteorCollision(){

    double dist;
    bool  controlCollision=false;

    for (int j=0;j<maxMeteorBonus;++j){
        if (bonusCome[j].bonusMeteor!=NULL){
            dist = sqrt((ship->position.x - bonusCome[j].bonusMeteor->position.x) * (ship->position.x - bonusCome[j].bonusMeteor->position.x)+
                        (ship->position.y - bonusCome[j].bonusMeteor->position.y) * (ship->position.y - bonusCome[j].bonusMeteor->position.y));
			
            //carpma olmas durumu
            if (dist < bonusCome[j].bonusMeteor->boundingSphereRadius/2 + (ship->shipHeight/3)){

                bonusCome[j].bonusMeteor->setObjectProperties();
                point-=3;
				
                shipExplode = true;
                shipExplosionSecond = 0;
                shipExplosionSpriteCounter = 0;
                ++ship->damage;
                audios->Play(3);
            }

        }
    }

}

void ShipBonusCollision(){

    double dist;

    for (int i=0; i<maxBonus ; ++i){

        if (bonus[i]!=NULL){
				
            dist = sqrt((ship->position.x - bonus[i]->position.x) * (ship->position.x - bonus[i]->position.x)+
                        (ship->position.y - bonus[i]->position.y) * (ship->position.y - bonus[i]->position.y));
		
            //carpma olmas durumu
            if (dist <= 1 + (ship->shipHeight/3)){
				
                if (bonus[i]->OilBonus){
                    ship->meter = 0;
				}
                else if (bonus[i]->HealthBonus){				
                    ship->damage = 0;
                }
				
                delete bonus[i];
                bonus[i]=NULL;
                --bonusCounter;
				
                audios->Play(4);
				
            }
        }
    }

}

void FireBonusCollision(){
	
    double dist;
    bool controlFirePtr=false;

    FireList::iterator fireIterator = fireList.begin();

    while (fireIterator != fireList.end()) {		
        Fire *firePtr = *fireIterator;
	
        for (int j=0; j<bonusCounter ; ++j){
            if (bonus[j]!=NULL ){
                dist = sqrt((firePtr->position.x - bonus[j]->position.x) * (firePtr->position.x - bonus[j]->position.x)+
                            (firePtr->position.y - bonus[j]->position.y) * (firePtr->position.y - bonus[j]->position.y));
				
                //carpma olmas durumu
                if (dist <= 1){
					
                    if (firePtr->type != DEATH_LINE_FIRE ){
                        //fire siliniyor				
                        FireList::iterator fireCurrent = fireIterator;
                        controlFirePtr = true;
                        ++fireIterator;
                        fireList.erase(fireCurrent);
                        delete firePtr;
                        firePtr = NULL;
                    }
            

                    delete bonus[j];
                    bonus[j]=NULL;
                    --bonusCounter;
               
                    break;
               
                }							
            }

            if (controlFirePtr){
                break;
            }
   
        }
		
        if ( !controlFirePtr )++fireIterator;
        controlFirePtr=false;
    }

}

void ShipEnemyFireCollision(){
	
    double dist;
	
    EnemyFireList::iterator enemyFireIterator = enemyFireList.begin();
	
    while (enemyFireIterator != enemyFireList.end()) {
		
        EnemyFire	*enemyFirePtr = *enemyFireIterator;

        dist = sqrt((ship->position.x - enemyFirePtr->firePosition.x) * (ship->position.x - enemyFirePtr->firePosition.x)+
                    (ship->position.y - enemyFirePtr->firePosition.y) * (ship->position.y - enemyFirePtr->firePosition.y));
				
        //carpma olmas durumu
        if ( dist <= (ship->shipHeight/3) ){

            point--;
            ++ship->damage;

            //enemy fire siliniyor
            EnemyFireList::iterator efCurrent = enemyFireIterator;
            ++enemyFireIterator;
            enemyFireList.erase(efCurrent);
            delete enemyFirePtr;
            enemyFirePtr = NULL;
	
            shipExplode = true;
            shipExplosionSecond = 0;
            shipExplosionSpriteCounter = 0;
			
            audios->Play(3);
        
        }
        else
            ++enemyFireIterator;
		
    }


}

void FireEnemyCollision(){
	
    double dist;
    bool controlFirePtr=false;
    bool controlEnemyPtr = false;

    FireList::iterator fireIterator = fireList.begin();
	
    while (fireIterator != fireList.end()) {		
        Fire *firePtr = *fireIterator;
		
        EnemyList::iterator enemyIterator = enemyList.begin();
        while (enemyIterator != enemyList.end()) {
			
            Enemy	*enemyPtr = *enemyIterator;
	
            dist =sqrt((firePtr->position.x - enemyPtr->position.x) * (firePtr->position.x - enemyPtr->position.x)+
                        (firePtr->position.y - enemyPtr->position.y) * (firePtr->position.y - enemyPtr->position.y));
					
            //carpma olmas durumu
            if (dist <= (enemyPtr->boundingSphereRadius/2)){
 				
                if (firePtr->type != DEATH_LINE_FIRE ){
                    //fire siliniyor				
                    FireList::iterator fireCurrent = fireIterator;
                    controlFirePtr = true;
                    ++fireIterator;
                    fireList.erase(fireCurrent);
                    delete firePtr;
                    firePtr = NULL;
                }
            

                ExplosionInfo *expInfo = new ExplosionInfo();
				
                expInfo->explosionType			= 2;
                expInfo->explosionPosition		= enemyPtr->position;
                expInfo->explosionSecond		= 0;
                expInfo->explosionSpriteCounter = 0;
				
                explosionInfoList.push_back(expInfo);
            
												
                EnemyList::iterator eCurrent = enemyIterator;
                controlEnemyPtr = true;
                ++enemyIterator;
                enemyList.erase(eCurrent);
                delete enemyPtr;			
				
                CreateEnemy();
				
                point+=5;
				
                audios->Play(2);

                break;
            }
			
            if (!controlEnemyPtr) ++enemyIterator;
            controlEnemyPtr = false;
        
        }
		
        if ( !controlFirePtr )++fireIterator;		
        controlFirePtr = false;

    }

}

void ShipEnemyCollision(){

    bool controlEnemyPtr = false;	
    double dist;

    EnemyList::iterator enemyIterator = enemyList.begin();	

    while (enemyIterator != enemyList.end()) {
		
        Enemy	*enemyPtr = *enemyIterator;
	
        dist =sqrt((ship->position.x - enemyPtr->position.x) * (ship->position.x - enemyPtr->position.x)+
                    (ship->position.y - enemyPtr->position.y) * (ship->position.y - enemyPtr->position.y));
	
        //carpma olmas durumu
        if (dist < (ship->shipHeight/3) + (enemyPtr->boundingSphereRadius/2)){
			
            point--;
            ++ship->damage;

			
            shipExplode = true;
            shipExplosionSecond = 0;
            shipExplosionSpriteCounter = 0;
			
            EnemyList::iterator eCurrent = enemyIterator;
            controlEnemyPtr = true;
            ++enemyIterator;
            enemyList.erase(eCurrent);
            delete enemyPtr;

            CreateEnemy();
			
            audios->Play(3);
		
        }
        
        if (!controlEnemyPtr) ++enemyIterator;
        controlEnemyPtr = false;
	
    }

}

void ShipWeaponBonusCollision(){

    WeaponBonusList::iterator weaponBonusIterator;

    double  dist;
    
    //Eer weapon bonus kt ise bonus iziliyor
    weaponBonusIterator = weaponBonusList.begin();
    
    while (weaponBonusIterator != weaponBonusList.end()){
        Bonus *b = *weaponBonusIterator ;				
        
        dist = sqrt((ship->position.x - b->position.x) * (ship->position.x - b->position.x)+
                        (ship->position.y - b->position.y) * (ship->position.y - b->position.y));
		
        //carpma olmas durumu
        if (dist <= 1 + (ship->shipHeight/3)){
			
            if (b->DoubleWeaponBonus){
                secondaryWeapon[DOUBLE_FIRE].counter +=20;
                if (activeWeapon == -1) {
                    secondaryWeapon[activeWeapon].active = false;
                    activeWeapon = DOUBLE_FIRE;
                    secondaryWeapon[activeWeapon].active = true;
                }
            }
            else if (b->TripleWeaponBonus){				
                secondaryWeapon[TRIPLE_FIRE].counter +=15;               
                if (activeWeapon == -1) {
                    secondaryWeapon[activeWeapon].active = false;
                    activeWeapon = TRIPLE_FIRE;
                    secondaryWeapon[activeWeapon].active = true;
                }
            }
            else if (b->DeathLineWeaponBonus){				
                secondaryWeapon[DEATH_LINE_FIRE].counter +=5;
                if (activeWeapon == -1) {
                    secondaryWeapon[activeWeapon].active = false;
                    activeWeapon = DEATH_LINE_FIRE;
                    secondaryWeapon[activeWeapon].active = true;
                }
            }
            else if (b->CircleWeaponBonus ){
                secondaryWeapon[CIRCLE_FIRE].counter +=2;
                if (activeWeapon == -1) {
                    secondaryWeapon[activeWeapon].active = false;
                    activeWeapon = CIRCLE_FIRE;
                    secondaryWeapon[activeWeapon].active = true;
                }
            }
            

            WeaponBonusList::iterator wbCurrent = weaponBonusIterator;
            ++weaponBonusIterator;
            weaponBonusList.erase(wbCurrent);
            delete b;
            b=NULL;

            audios->Play(4);
            
        }
        else
            ++weaponBonusIterator;

           
    }

    


}

//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------

//Oyuncunun puan yazdrlyor.
void PrintPoint(bool finishScreen){
    char  buffer[200];
	
    glPushMatrix();

        glBlendFunc(GL_ONE,GL_ONE);
        glEnable(GL_BLEND);

        glNormal3f(0.0f,0.0f,1.0f);
        glColor3f(0.0f,1.0f,0.0f);		
        glScalef(0.8f,0.8f,0.8f);		

        glEnable(GL_TEXTURE_2D);
        glFontBegin(&font);
            
           glPushMatrix();
           if (!finishScreen){
                sprintf( buffer , "Score:%d", point );
                glTranslatef(-7.0f,5.0f,0.0f);
                glFontTextOut(buffer, MIN_X, MAX_Y,0);
            }
            else{
                
                glColor3f(1.0f,0.0f,0.0f);		
                glScalef(1.5f,1.5f,1.5f);
                sprintf( buffer , "GAME OVER", point );
                glFontTextOut(buffer, -5, 12 ,0);
                sprintf( buffer , "Score:%d", point );
                glFontTextOut(buffer, -5, 10 ,0);
                
            }           
            
            glPopMatrix();
            
            //SecondaryWeapon sayilari yazdiriliyor.
            glColor3f(1.0f,0.2f,0.0f);		
            sprintf( buffer , "x%d", secondaryWeapon[0].counter);
            glFontTextOut(buffer, MIN_X-2, MIN_Y-7,0);
            sprintf( buffer , "x%d", secondaryWeapon[1].counter);
            glFontTextOut(buffer, MIN_X+4, MIN_Y-7,0);
            sprintf( buffer , "x%d", secondaryWeapon[2].counter);
            glFontTextOut(buffer, MIN_X+13,MIN_Y-7,0);          
            sprintf( buffer , "x%d", secondaryWeapon[3].counter);
            glFontTextOut(buffer, MIN_X+21,MIN_Y-7,0);          


        glFontEnd();

        glDisable(GL_TEXTURE_2D);		
        glDisable(GL_BLEND);

    glPopMatrix();

}

//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
//Benzin bonusunun gelmesinin kontrolu yapiliyor
void ControlOilBonus(){
	
    bool controlBonus=false;

    //Bonuslardan biri gnderilmis ve gecis halinde yani bitmemis ise bonus var...  
    for (int i=0;i<5;++i)
        if (bonusCome[i].come && !bonusCome[i].passive) controlBonus=true;
	

    if (!controlBonus) {

        //Geminin benzini belirli oranlarda iken bonus ksn
        if (ship->meter * 4 > ship->oil && ship->meter * 3 < ship->oil ){		
		
            if (!bonusCome[0].come){
                bonusCome[0].come=true;
                bonusCome[0].type=OIL_BONUS;
                bonusCome[0].bonusMeteor->setBonusType(OIL_BONUS,bonusOilTexture);
            }
        
        }
        else if (ship->meter * 3 > ship->oil && ship->meter * 2 < ship->oil){		
		    
            if (!bonusCome[1].come){
                bonusCome[1].come=true;
                bonusCome[1].type=OIL_BONUS;
                bonusCome[1].bonusMeteor->setBonusType(OIL_BONUS,bonusOilTexture);	
            }

        }
        else if (ship->meter * 2 > ship->oil && ship->meter * 1.5 < ship->oil){
            
            if (!bonusCome[2].come){
                bonusCome[2].come=true;
                bonusCome[2].type=OIL_BONUS;
                bonusCome[2].bonusMeteor->setBonusType(OIL_BONUS,bonusOilTexture);
            }
        
        }
        else if (ship->meter *1.5> ship->oil && ship->meter * 1.2 < ship->oil){		
		
            if (!bonusCome[3].come){
                bonusCome[3].come=true;
                bonusCome[3].type=OIL_BONUS;
                bonusCome[3].bonusMeteor->setBonusType(OIL_BONUS,bonusOilTexture);
            }
        
        }
        else if (ship->meter *1.2> ship->oil){		
			
            if (!bonusCome[4].come){
                bonusCome[4].come=true;
                bonusCome[4].type=OIL_BONUS;
                bonusCome[4].bonusMeteor->setBonusType(OIL_BONUS,bonusOilTexture);
            }
        
        }
    
    }

}

//Health bonusunun gelmesinin kontrolu yapiliyor
void ControlHealthBonus(){

    bool controlBonus=false;

    //Bonuslardan biri gnderilmis ve gecis halinde yani bitmemis ise bonus var...  
    for (int i=5;i<10;++i)
        if (bonusCome[i].come && !bonusCome[i].passive) controlBonus=true;
	
    
    if (!controlBonus) {
	
        //Gemi belirli oranlarda hasar aldi ise bonus gnderilsin
        if (ship->damage * 4 > ship->hitPoint && ship->damage * 3 < ship->hitPoint){		
		    
            if (!bonusCome[5].come){
                bonusCome[5].come=true;
                bonusCome[5].type=HEALTH_BONUS;
                bonusCome[5].bonusMeteor->setBonusType(HEALTH_BONUS,bonusHealthTexture);	
            }
        
        }
        else if (ship->damage * 3 > ship->hitPoint && ship->damage * 2 < ship->hitPoint){		
			
            if (!bonusCome[6].come){
                bonusCome[6].come=true;
                bonusCome[6].type=HEALTH_BONUS;
                bonusCome[6].bonusMeteor->setBonusType(HEALTH_BONUS,bonusHealthTexture);	
            }
        
        }
        else if (ship->damage * 2 > ship->hitPoint && ship->damage * 1.5 < ship->hitPoint){

            if (!bonusCome[7].come){
                bonusCome[7].come=true;
                bonusCome[7].type=HEALTH_BONUS;
                bonusCome[7].bonusMeteor->setBonusType(HEALTH_BONUS,bonusHealthTexture);	
            }
        
        }
        else if (ship->damage *1.5> ship->hitPoint && ship->damage * 1.2 < ship->hitPoint){

            if (!bonusCome[8].come){
                bonusCome[8].come=true;
                bonusCome[8].type=HEALTH_BONUS;
                bonusCome[8].bonusMeteor->setBonusType(HEALTH_BONUS,bonusHealthTexture);
            }
        
        }
        else if (ship->damage *1.2> ship->hitPoint){		
			
			if (!bonusCome[9].come){
				bonusCome[9].come=true;
				bonusCome[9].type=HEALTH_BONUS;
				bonusCome[9].bonusMeteor->setBonusType(HEALTH_BONUS,bonusHealthTexture);	
			}

        }
	
    }
	
}


/*----------------------------------------------------------------------------------
----------------		Grntlenen Ekranlar(Render Fonksiyonlar)	----------------
----------------------------------------------------------------------------------*/

//-------------------------------- Giris Ekrani ------------------------------------
int renderMenu(){
	
    static int		activeMenuItem=1;
    static float	shipPositionX=-25, shipPositionY=20;
    static int		directionX=1,directionY=0; ;
	
    ComputeComputerVelocity(false);	
	
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();
	
        glTranslatef(0.0f,0.0f,-55.0f);
		
        char  buffer[200];		
        
        glNormal3f(0.0f,0.0f,1.0f);
        glColor3f(1.0f,1.0f,1.0f);		
		
        glBindTexture(GL_TEXTURE_2D, splash);
        glEnable(GL_TEXTURE_2D);
		
        glBegin(GL_QUADS);
            glTexCoord2f(1.0f,1.0f); glVertex2f( 10.0f,17.0f);
            glTexCoord2f(0.0f,1.0f); glVertex2f(-10.0f,17.0f);
            glTexCoord2f(0.0f,0.0f); glVertex2f(-10.0f,-3.0f);
            glTexCoord2f(1.0f,0.0f); glVertex2f( 10.0f,-3.0f);
        glEnd();		
		
        //Gemi hareket ettiriliyor		
        glColor3f(1.0f,1.0f,1.0f);
        glBindTexture(GL_TEXTURE_2D, shipTex);
		
        if (directionX==-1){
            shipPositionX -= deltaTime * 10 ;
            if (shipPositionX<-25) {
                directionX=0;	directionY=1;
            }		
        }
        else if (directionX==1){
            shipPositionX += deltaTime * 10 ;
            if (shipPositionX>25) {
                directionX=0;	directionY=-1;
            }		
        }
        else if (directionY==-1){
            shipPositionY -= deltaTime * 10 ;
            if (shipPositionY<-20) {
                directionX=-1;		directionY=0;
            }		
        }
        else if (directionY==1){
            shipPositionY += deltaTime * 10 ;
            if (shipPositionY>20) {
                directionX=1;	directionY=0;
            }		
        }
		
        glPushMatrix();

            glTranslatef(0.0f,0.0f,0.0f);
			
            glBegin(GL_QUADS);
                glTexCoord2f(1.0f,1.0f); glVertex2f(shipPositionX+2.0f,shipPositionY+2.0f);
                glTexCoord2f(0.0f,1.0f); glVertex2f(shipPositionX-2.0f,shipPositionY+2.0f);
                glTexCoord2f(0.0f,0.0f); glVertex2f(shipPositionX-2.0f,shipPositionY-2.0f);
                glTexCoord2f(1.0f,0.0f); glVertex2f(shipPositionX+2.0f,shipPositionY-2.0f);
            glEnd();
		
        glPopMatrix();
		
        //---------------------------

        glFontBegin(&font);
			
            glPushMatrix();			
                glColor3f(0.9f,0.6f,0.1f);
                glTranslatef(-17.0f,-16.0f,0.0f);
                glScalef(0.7f,0.7f,0.7f);
                sprintf( buffer , "Produced By:Neslihan AYDINOGLU (hibbit)/ Sep 2004");
                glFontTextOut(buffer, 0, 0,1);
            glPopMatrix();
			
        glFontEnd();
		
        glPushMatrix();
				
                //down tuuna baslma durumu
                if (dkey){
                    ++activeMenuItem;
                    if (activeMenuItem>3) activeMenuItem=3;
                    dkey=false;
                }

                //up tuuna baslma durumu
                if (ukey){
                    --activeMenuItem;
                    if (activeMenuItem<1) activeMenuItem=1;
                    ukey=false;
                }
				
                glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
                glEnable(GL_BLEND);	
	
                glPushMatrix();
					
                    glColor3f(1.0f,1.0f,1.0f);
				
                    if (activeMenuItem==1){
                        glBindTexture(GL_TEXTURE_2D, menuStartActive);
                        glTranslatef(-1.0f,-5.0f,0.0f);
                    }
                    else{
                        glBindTexture(GL_TEXTURE_2D, menuStartPassive);
                        glTranslatef(-1.0f,-5.0f,0.0f);					
                    }					
                    glBegin(GL_QUADS);
                        glTexCoord2f(1.0f,1.0f); glVertex2f( 3.5f, 3.5f);
                        glTexCoord2f(0.0f,1.0f); glVertex2f(-3.5f, 3.5f);
                        glTexCoord2f(0.0f,0.0f); glVertex2f(-3.5f,-3.5f);
                        glTexCoord2f(1.0f,0.0f); glVertex2f( 3.5f,-3.5f);
                    glEnd();		
                
                glPopMatrix();
                
                glPushMatrix();
                
                    if (activeMenuItem==2){
                        glBindTexture(GL_TEXTURE_2D, menuControlsActive);
                        glTranslatef(-1.0f,-8.0f,0.0f);						
                    }
                    else{
                        glBindTexture(GL_TEXTURE_2D, menuControlsPassive);
                        glTranslatef(-1.0f,-8.1f,0.0f);						
					}

                    glBegin(GL_QUADS);
                        glTexCoord2f(1.0f,1.0f); glVertex2f( 3.5f, 3.5f);
                        glTexCoord2f(0.0f,1.0f); glVertex2f(-3.5f, 3.5f);
                        glTexCoord2f(0.0f,0.0f); glVertex2f(-3.5f,-3.5f);
                        glTexCoord2f(1.0f,0.0f); glVertex2f( 3.5f,-3.5f);
                    glEnd();		

                glPopMatrix();
				
                glPushMatrix();
                    if (activeMenuItem==3){
                        glBindTexture(GL_TEXTURE_2D, menuExitActive);						
						glTranslatef(-1.0f,-11.0f,0.0f);						
                    }
                    else{
                        glBindTexture(GL_TEXTURE_2D, menuExitPassive);
                        glTranslatef(-1.0f,-11.0f,0.0f);						
                    }
                    glBegin(GL_QUADS);
                        glTexCoord2f(1.0f,1.0f); glVertex2f( 3.5f, 3.5f);
                        glTexCoord2f(0.0f,1.0f); glVertex2f(-3.5f, 3.5f);
                        glTexCoord2f(0.0f,0.0f); glVertex2f(-3.5f,-3.5f);
                        glTexCoord2f(1.0f,0.0f); glVertex2f( 3.5f,-3.5f);
                    glEnd();		
                
                glPopMatrix();

                glDisable(GL_BLEND);		
			
            glPopMatrix();
		
        glDisable(GL_TEXTURE_2D);		
		
    SDL_GL_SwapBuffers();

    if (enterKey){
        if (activeMenuItem==2){
            activeMenuItem=1;
            enterKey=false;
            return 2;
        }
        else if (activeMenuItem==1){
            enterKey = false;
            activeMenuItem = 1;
            return 1;
        }
        return activeMenuItem;
    }
    else
        return 0;

}


//----------------------- Kontrollerin anlatildigi ekran --------------------------------
int renderControls(){


    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();
	
        glTranslatef(0.0f,0.0f,-55.0f);
		
        char  buffer[200];
		
        glNormal3f(0.0f,0.0f,1.0f);
        glColor3f(1.0f,1.0f,1.0f);		
		
        glBindTexture(GL_TEXTURE_2D, splash);
        glEnable(GL_TEXTURE_2D);
		
        glBegin(GL_QUADS);
            glTexCoord2f(1.0f,1.0f); glVertex2f( 5.0f,20.0f);
            glTexCoord2f(0.0f,1.0f); glVertex2f(-5.0f,20.0f);
            glTexCoord2f(0.0f,0.0f); glVertex2f(-5.0f,10.0f);
            glTexCoord2f(1.0f,0.0f); glVertex2f( 5.0f,10.0f);
        glEnd();		
		
        glFontBegin(&font);
			
            glPushMatrix();
				
                glColor3f(0.1f,0.6f,0.1f);
                glScalef(0.7f,0.7f,0.7f);
				
                glTranslatef(-40.0f,15.0f,0.0f);
                sprintf( buffer , "Space , q     : Fire");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "w             : Secondary weapon fire.");
                glFontTextOut(buffer, 0, 0,1);
				                
                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "Up   ,  Keypad 8 : Move up.");				
                glFontTextOut(buffer, 0, 0,1);

                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "Down ,  Keypad 5 : Move down.");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "Left ,  Keypad 4 : Move left.");
                glFontTextOut(buffer, 0, 0,1);

                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "Right , Keypad 6 : Move right.");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "TAB   : Switches secondary weapon.");
                glFontTextOut(buffer, 0, 0,1);
				                
                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "P     : Pause game.");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(0.0f,-2.0f,0.0f);
                sprintf( buffer , "Esc   : Quit game.");
                glFontTextOut(buffer, 0, 0,1);
												
                glTranslatef(6.0f,-3.0f,0.0f);
                sprintf( buffer , ":First enemy.");
                glFontTextOut(buffer, 0, 0,1);				
				
                glTranslatef(25.0f,0.0f,0.0f);
                sprintf( buffer , ":Double weapon bonus.");
                glFontTextOut(buffer, 0, 0,1);				
				
                glTranslatef(-25.0f,-4.0f,0.0f);
                sprintf( buffer , ":Seconda enemy");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(25.0f,0.0f,0.0f);
                sprintf( buffer , ":Triple weapon bonus.");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(-25.0f,-4.0f,0.0f);
                sprintf( buffer , ":Thirth Enemy.");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(25.0f,0.0f,0.0f);
                sprintf( buffer , ":Death line weapon bonus.");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(-25.0f,-4.0f,0.0f);
                sprintf( buffer , ":Oil  bonus meteor.");
                glFontTextOut(buffer, 0, 0,1);				
                
                glTranslatef(25.0f,0.0f,0.0f);
                sprintf( buffer , ":Circle weapon bonus.");
                glFontTextOut(buffer, 0, 0,1);
				
                glTranslatef(-25.0f,-4.0f,0.0f);
                sprintf( buffer , ":Health bonus meteor.");
                glFontTextOut(buffer, 0, 0,1);
				
                glColor3f(0.9f,0.2f,0.1f);				
				
                glTranslatef(20.0f,-8.0f,0.0f);
                sprintf( buffer , "Press ESC to return menu page.");
                glFontTextOut(buffer, 0, 0,1);				

            glPopMatrix();
			
            glPushMatrix();
			
                glScalef(0.7f,0.7f,0.7f);
					
                glBlendFunc(GL_ONE,GL_ONE);
                glEnable(GL_BLEND);
                glColor3f(1.0f,1.0f,1.0f);
				
                glTranslatef(-39.0f,-5.0f,0.0f);				                
                
                glBindTexture(GL_TEXTURE_2D, enemy1);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 2.0f, 2.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-2.0f, 2.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-2.0f,-2.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 2.0f,-2.0f);
                glEnd();				

                
                glTranslatef(27.0f,0.0f,0.0f);
				glBindTexture(GL_TEXTURE_2D, secondaryWeapon[0].texture);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 1.0f, 1.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-1.0f, 1.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-1.0f,-1.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 1.0f,-1.0f);
                glEnd();                
				
                glTranslatef(-27.0f,-4.0f,0.0f);
				
                glBindTexture(GL_TEXTURE_2D, enemy2);
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 2.0f, 2.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-2.0f, 2.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-2.0f,-2.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 2.0f,-2.0f);
                glEnd();

                glTranslatef(27.0f,0.0f,0.0f);
				glBindTexture(GL_TEXTURE_2D, secondaryWeapon[1].texture);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 1.0f, 1.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-1.0f, 1.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-1.0f,-1.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 1.0f,-1.0f);
                glEnd();			

                glTranslatef(-27.0f,-4.0f,0.0f);
				
                glBindTexture(GL_TEXTURE_2D, enemy3);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 2.0f, 2.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-2.0f, 2.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-2.0f,-2.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 2.0f,-2.0f);
                glEnd();
                
                glTranslatef(27.0f,0.0f,0.0f);
				glBindTexture(GL_TEXTURE_2D, secondaryWeapon[2].texture);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 1.0f, 1.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-1.0f, 1.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-1.0f,-1.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 1.0f,-1.0f);
                glEnd();                
				
                glTranslatef(0.0f,-4.0f,0.0f);
				glBindTexture(GL_TEXTURE_2D, secondaryWeapon[3].texture);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 1.0f, 1.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-1.0f, 1.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-1.0f,-1.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 1.0f,-1.0f);
                glEnd();				
                
                glTranslatef(-27.0f,0.0f,0.0f);
				
                glBindTexture(GL_TEXTURE_2D, bonusOilTexture);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 2.0f, 2.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-2.0f, 2.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-2.0f,-2.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 2.0f,-2.0f);
                glEnd();				
				
                glColor3f(1.0f,1.0f,1.0f);				
                glBindTexture(GL_TEXTURE_2D, meteorSprite1[0]);
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 1.0f,1.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-1.0f,1.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-1.0f,-1.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 1.0f,-1.0f);
                glEnd();						
				
                glTranslatef(0.0f,-4.0f,0.0f);
				
                glColor3f(0.0f,1.0f,0.0f);
                glBindTexture(GL_TEXTURE_2D, bonusHealthTexture);				
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 2.0f, 2.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-2.0f, 2.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-2.0f,-2.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 2.0f,-2.0f);
                glEnd();				
				
                glColor3f(1.0f,1.0f,1.0f);				
                glBindTexture(GL_TEXTURE_2D, meteorSprite1[0]);
                glBegin(GL_QUADS);
                    glTexCoord2f(1.0f,1.0f); glVertex2f( 1.0f,1.0f);
                    glTexCoord2f(0.0f,1.0f); glVertex2f(-1.0f,1.0f);
                    glTexCoord2f(0.0f,0.0f); glVertex2f(-1.0f,-1.0f);
                    glTexCoord2f(1.0f,0.0f); glVertex2f( 1.0f,-1.0f);
                glEnd();
				

                glDisable(GL_BLEND);		
		
            glPopMatrix();
			

        glFontEnd();
		
        glDisable(GL_TEXTURE_2D);		
		
    SDL_GL_SwapBuffers();

    return 0;

}

//---------------------------------------------------------------------------------

void renderEnemies(){
	
    bool controlEnemyPtr = false;
    int j=0;
    EnemyList::iterator enemyIterator = enemyList.begin();	

    while (enemyIterator != enemyList.end()) {	
		
        Enemy	*e = *enemyIterator;
        e->setShipPosition(ship->position);
		
        switch (e->renderObject (deltaTime)){
	    		
            //Enemy iin fire ret
            case 1:
                CreateEnemyFire(e);
                break;

            //Enemy silinsin
            case 3:
				
                EnemyList::iterator eCurrent = enemyIterator;
                controlEnemyPtr = true;
                ++enemyIterator;
                enemyList.erase(eCurrent);
                delete e;
				
                CreateEnemy();

                break;
		
        }

        if (!controlEnemyPtr) ++enemyIterator;
        controlEnemyPtr = false;
    
    }			

}

//Enemylerin firelari iziliyor
void renderEnemyFires(){
	
    EnemyFireList::iterator enemyFireIterator = enemyFireList.begin();
    while (enemyFireIterator != enemyFireList.end()) {
		
        EnemyFire *ef = *enemyFireIterator;				
			
        //silinsin
        if (ef->renderEnemyFire(deltaTime) == 1){
			
            EnemyFireList::iterator efCurrent = enemyFireIterator;
            ++enemyFireIterator;
            enemyFireList.erase(efCurrent);
            delete ef;
        }
        else
            ++enemyFireIterator;
    } 
			
}

void renderShipFires(){
	
    bool controlFire=false;

    FireList::iterator fireIterator = fireList.begin();	

    while (fireIterator != fireList.end()) {
		
        Fire *firePtr = *fireIterator;
        firePtr->UpdateFire(deltaTime);
                
        if (firePtr->type == CIRCLE_FIRE || firePtr->type == DEATH_LINE_FIRE ) {
            
            if (firePtr->explosionCreationTime >= 0.1 ) {

                ExplosionInfo *expInfo = new ExplosionInfo();
				    
                expInfo->explosionType			= 1;
                expInfo->explosionPosition		= firePtr->position;
                expInfo->explosionSecond		= 0;
                expInfo->explosionSpriteCounter = 0;
				    
                explosionInfoList.push_back(expInfo);
                firePtr->explosionCreationTime = 0;
            }
            
        }
        
        if ( firePtr->RenderFire()==1){
         
            //fire siliniyor
            FireList::iterator fireCurrent = fireIterator;
            ++fireIterator;
            fireList.erase(fireCurrent);
            delete firePtr;
            firePtr = NULL;   
         
        }
        else
            ++fireIterator;
    }
	
}

void Explosion(int dimension,Vec3d position,int expType){

    float fx,fy;
	
    fx=(fmod(dimension,4))*0.25;
    fy=1-((dimension/4)*0.25);
	
    if (expType==1)
        glColor3f(1.0f,1.0f,1.0f);
    else
        glColor3f(1.0f,0.5f,0.0f);
	
    glBindTexture(GL_TEXTURE_2D, expText);
    glEnable(GL_TEXTURE_2D);		
    glDisable(GL_LIGHTING);
	
    glBlendFunc(GL_ONE,GL_ONE);	
    glEnable(GL_BLEND);	
	
    glBegin(GL_QUADS);
		
        glPushMatrix();		
		
        glTexCoord2f(fx,fy-0.25f);		    glVertex3f(position.x-2.0f,position.y-2.0f,1.1f);
        glTexCoord2f(fx+0.25f,fy-0.25f);	glVertex3f(position.x+2.0f,position.y-2.0f,1.1f);
        glTexCoord2f(fx+0.25f,fy);		    glVertex3f(position.x+2.0f,position.y+2.0f,1.1f);
        glTexCoord2f(fx,fy);			    glVertex3f(position.x-2.0f,position.y+2.0f,1.1f);
		
        glPopMatrix();

    glEnd();
	
    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);	
    glEnable(GL_LIGHTING);

}


//Patlama olan gktaslarinin spritelari basiliyor.
void renderExplosions(){
	
    ExplosionInfoList::iterator explosionInfoIterator = explosionInfoList.begin();	
	
    while (explosionInfoIterator != explosionInfoList.end()) {
		
        ExplosionInfo *explosion = *explosionInfoIterator;

        explosion->explosionSecond += deltaTime;
	
        //Belirli araliklar ile sira sira spritelar grntlensin
        if (explosion->explosionSecond > 0.1 ){
            explosion->explosionSpriteCounter++;
            explosion->explosionSecond = 0;			
        }
		
        //Sprite texture 16 parcadan olusuyor.16 parcada gsterilince patlamayi bitir.
        if (explosion->explosionSpriteCounter >= 16){
            //Explosion Info listeden siliniyor
            ExplosionInfoList::iterator expInfoCurrent = explosionInfoIterator;
            ++explosionInfoIterator;
            explosionInfoList.erase(expInfoCurrent);
            delete explosion;
            explosion=NULL;
		}
        else{
            Explosion(explosion->explosionSpriteCounter,explosion->explosionPosition,explosion->explosionType);
            ++explosionInfoIterator;			
        }	
    
    }

}

//Patlama olan geminin spritelari basiliyor.
void renderShipExplosion(){
		
    if (shipExplode){
        shipExplosionSecond += deltaTime;
		
        if (shipExplosionSecond > 0.1){			
            ++shipExplosionSpriteCounter ;			
            shipExplosionSecond=0;
        }
		
        if(shipExplosionSpriteCounter >= 16){
            shipExplode=false;
            shipExplosionSecond=0;
            shipExplosionSpriteCounter =0;
        }
        else
            ship->Explosion (shipExplosionSpriteCounter);
			
    }		

}

//Geminin benzini bitti veya cok fazla hasar aldi dsyor.
int renderFallShip(int death){
	
    int i;
	
    MeteorList::iterator meteorIterator = meteorList.begin();
    EnemyList::iterator enemyIterator = enemyList.begin();
	WeaponBonusList::iterator weaponBonusIterator =weaponBonusList.begin();

    int result = ship->ShipDead (deltaTime);
			
    if (result==1){
        Sleep(1000);
        playingTime=0;
        lastPlayingTime=0;
        return result;
    }

    screen->RenderScreenBackground();
	    
    static float ce =0;
    
    ce += deltaTime ;

    if (ce > 0.2 ) {

        ExplosionInfo *expInfo = new ExplosionInfo();
		    
        Vec3d p = ship->position;
        
        expInfo->explosionType			= 1;
        expInfo->explosionPosition		= p;
        expInfo->explosionSecond		= 0;
        expInfo->explosionSpriteCounter = 0;
		    
        explosionInfoList.push_back(expInfo);
        ce = 0;
    }

    ship->renderShip();
    renderShipExplosion();
	
    
    //meteorlar iziliyor		
    while (meteorIterator != meteorList.end()){
        Meteor *m = *meteorIterator;				
        m->renderObject (deltaTime);
        ++meteorIterator;
    }
	
	
    while (enemyIterator != enemyList.end()) {
        Enemy	*enemyPtr = *enemyIterator;
        enemyPtr->renderObject (deltaTime);	
        ++enemyIterator;
    }
	
		
    //Bonusu olan meteorlar iziliyor
    for (i=0;i<maxMeteorBonus;++i){
		
        //Bonus geliyorsa ve geip bitmedi ise izilsin
        if (bonusCome[i].come && !bonusCome[i].passive)
            if (!bonusCome[i].bonusMeteor->bonusFinish)
                bonusCome[i].bonusMeteor->renderObject (deltaTime);		
            else {
                bonusCome[i].passive=true;
            }
    }	
    
    //Eer weapon bonus kt ise bonus iziliyor
    weaponBonusIterator = weaponBonusList.begin();
    while (weaponBonusIterator != weaponBonusList.end()){
        Bonus *b = *weaponBonusIterator ;				
        b->RenderBonus(deltaTime * 10);
        ++weaponBonusIterator ;
    }

    //Patlama efektleri iziliyor
    renderExplosions();
			
    sky->renderSky (deltaTime);

    //Oyuncunun puani yazdiriliyor
    PrintPoint(true);
	
    screen->RenderScreenFrame(death,deltaTime);
    SDL_GL_SwapBuffers();			

    return result;
}

void renderPauseTexture(float dt){

    static float dt_t = 0;
    dt_t += dt;
    
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);

    glBindTexture(GL_TEXTURE_2D, pauseText);
    glEnable(GL_TEXTURE_2D);		
	
    glPushMatrix();
        glBegin(GL_QUADS);
            glColor3f(1,1,1);
            glTexCoord2f(1,1); glVertex3f(8,8,1);
            glTexCoord2f(0,1); glVertex3f(0,8,1);
            glTexCoord2f(0,0); glVertex3f(0,0,1);
            glTexCoord2f(1,0); glVertex3f(8,0,1);
        glEnd(); 
    glPopMatrix();

    glDisable(GL_TEXTURE_2D);		
    glDisable(GL_BLEND);
	
    SDL_GL_SwapBuffers();

}

//---------------------------- Oyun Ekrani --------------------------------------------
int renderScene(int death,bool pause) {
	
    int i,j;
	
    MeteorList::iterator meteorIterator;
    EnemyList::iterator enemyIterator;
    FireList::iterator fireIterator;
    WeaponBonusList::iterator weaponBonusIterator;

    ComputeComputerVelocity(pause);
	
    if (pause) 
        renderPauseTexture(deltaTime);

    else{

        //Oyunun balangicindan itibaren gecen zaman playingTime deerinde tutuluyor.
        //Bu degere gre gktalarinin gelis says ayarlanacak		
        ComputeMeteorInTheScene(playingTime += deltaTime);
		
        CreateWeaponBonus();

        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        glLoadIdentity();		
			
            glTranslatef(0,0,-55);
			
            //eer gemi benzini bitmemis ve yeterince hasar almamis ise izdirilsin
            if (ship->damage < ship->hitPoint &&  ship->meter < ship->oil )
                ship->updateShip(ukey,dkey,lkey,rkey,deltaTime);		
            else{
				
                return renderFallShip(death);			
            }
			
            //Ekrandaki sabit sekiller iziliyor
            screen->RenderScreenBackground();
			
            //arpma kontrolleri yaplyor
            ShipMeteorCollision();
            ShipBonusMeteorCollision();
            ShipBonusCollision();
            ShipEnemyFireCollision();		
            ShipEnemyCollision();
            ShipWeaponBonusCollision();
         
            FireBonusMeteorCollision();
            FireMeteorCollision();			
            FireBonusCollision();		
            FireEnemyCollision();		

            meteorIterator = meteorList.begin();
            while (meteorIterator != meteorList.end()) {
                Meteor *m = *meteorIterator;				
                m->renderObject (deltaTime);		
                ++meteorIterator;
            } 
			           
            renderEnemies();			
            renderEnemyFires();
            
            ControlOilBonus();
            ControlHealthBonus();			
    
            
            //Bonusu olan meteorler iziliyor		
            for (i=0;i<maxMeteorBonus;++i){
                //Bonus geip bitmedi ise izilsin
                if (bonusCome[i].come && !bonusCome[i].passive)
                    if (!bonusCome[i].bonusMeteor->bonusFinish)
                        bonusCome[i].bonusMeteor->renderObject (deltaTime);		
                    else 
                        bonusCome[i].passive=true;
			
            }							
			
            
            //Eer bonus kt ise bonus iziliyor
            int control=0 ;
            for (j=0;j<maxBonus;++j){
                if (control==bonusCounter)
                    break;
                if (bonus[j]!=NULL){
                    bonus[j]->RenderBonus(deltaTime * 10 ) ;
                    ++control;
                    //Bonus grntden ikti ise silinsin
                    if ( bonus[j]->position.x < MIN_X  || bonus[j]->position.y < MIN_Y || bonus[j]->position.y >MAX_Y){
                        delete bonus[j];
                        bonus[j]=NULL;
                        --bonusCounter;
                    }
                }
            }	
			

           //Eer weapon bonus kt ise bonus iziliyor
           weaponBonusIterator = weaponBonusList.begin();
           while (weaponBonusIterator != weaponBonusList.end()){
                Bonus *b = *weaponBonusIterator ;				
                b->RenderBonus(deltaTime * 10);
                ++weaponBonusIterator ;
           }

            //Patlama efektleri iziliyor
            renderExplosions();
			
            //Ekranda bulunan bilgi verici nesneler iziliyor
            sky->renderSky (deltaTime);		
            screen->RenderScreenFrame(death,deltaTime);
			                        
            //Gemi iziliyor 
            ship->renderShip();
			
            //Eer gemide bir hasar olutu ise patlama efekti iziliyor
            renderShipExplosion();
			
            //Geminin atesleri iziliyor
            renderShipFires();
			
            //Oyuncunun puan yazdrlyor
            PrintPoint(false);		
		SDL_GL_SwapBuffers();
	
    }
    return 0;
}

//------------------------------ Final Ekrani -------------------------------------------
void renderFinish(int type){
	
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glLoadIdentity();
	
        glTranslatef(0,0,-55);
		
        char  buffer[200];
		
        glNormal3f(0,0,1);
		
        glEnable(GL_TEXTURE_2D);
        glFontBegin(&font);
			
            glPushMatrix();
			
                glScalef(0.7f,0.7f,0.7f);
				
                glColor3f(0.9f,0.5f,0.1f);		
                sprintf( buffer , "Neslihan /* hibbit */");
                glFontTextOut(buffer, -10, 0,1);				
				
                glColor3f(0.9f,0.2f,0.1f);		
                sprintf( buffer , "Thanks to:");
                glFontTextOut(buffer, -7, -6,0);
                sprintf( buffer , "Deniz /* zilog */");
                glFontTextOut(buffer, -9, -8,0);
                sprintf( buffer , "Burak /* BuRock */");
                glFontTextOut(buffer, -9, -10,0);				
				
				
                glColor3f(1.0f,1.0f,0.1f);
			    sprintf( buffer , "Press ESC to quit.");
                glFontTextOut(buffer, -9, -25,1);

            glPopMatrix();

        glFontEnd();
				
        glBindTexture(GL_TEXTURE_2D, splash);

        glColor3f(1.0f,1.0f,1.0f);
        glBegin(GL_QUADS);
            glTexCoord2f(1.0f,1.0f); glVertex2f( 5.0f,20.0f);
            glTexCoord2f(0.0f,1.0f); glVertex2f(-5.0f,20.0f);
            glTexCoord2f(0.0f,0.0f); glVertex2f(-5.0f,10.0f);
            glTexCoord2f(1.0f,0.0f); glVertex2f( 5.0f,10.0f);
        glEnd();
		
        glDisable(GL_TEXTURE_2D);		
		
    SDL_GL_SwapBuffers();
	
}
//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------


/*-------------------------------------------------------------------------------- --
----------------				TUA BASMA KONTROLLER				----------------
----------------------------------------------------------------------------------*/
void keyPressed(SDLKey sym) {
	
    switch (sym){
		
        if (ship->damage < ship->hitPoint){
            case SDLK_1:
                menuKey = 1;
                break;
            case SDLK_2:
                menuKey = 2;
                break;
            case SDLK_UP:
            case SDLK_KP8:

                ukey = true;
                dkey = false;
                break;
            case SDLK_DOWN:
            case SDLK_KP5:
                dkey = true;
                ukey = false;
                break;
            case SDLK_LEFT:
            case SDLK_KP4:
                lkey = true;
                rkey = false;
                break;
            case SDLK_RIGHT:
            case SDLK_KP6:
                rkey = true;
                lkey = false;
                break;
            case SDLK_RETURN:   
                enterKey=true;
                break;
            
            //Ana silah atesi
            case SDLK_SPACE:
            case SDLK_q:    
            {
            
                Vec3d spos = ship->position;
                Vec3d fireVel = {0.5,0,0};
                             
                Fire *f=new Fire(spos,fireTex,fireVel,FIRE_LIFE_TIME);
                fireList.push_back(f);
                audios->Play(1);
                break;

            }
            
            //Ikincil silah atesi
            case SDLK_w:{                

                if (activeWeapon!=-1){
                    switch (secondaryWeapon[activeWeapon].type){
                    
                        case DOUBLE_FIRE:{
                            Vec3d spos = ship->position;
                            Vec3d fireVel = {0.5f,0,0};
                            spos.y += 0.5f;
                            fireList.push_back(new Fire(spos,secondaryWeaponFireText,fireVel,FIRE_LIFE_TIME));
                            spos.y -= 1.0f;
                            fireList.push_back(new Fire(spos,secondaryWeaponFireText,fireVel,FIRE_LIFE_TIME));

                            audios->Play(1);	
                            --secondaryWeapon[activeWeapon].counter;
                            if (secondaryWeapon[activeWeapon].counter==0){
                                secondaryWeapon[activeWeapon].active =false;
                                SetActiveSecondaryWeapon();
                            }
                            break;
                        }
                        case TRIPLE_FIRE:{
                            Vec3d spos = ship->position;
                            Vec3d fireVel = {0.5f,0,0};
                            spos.y += 1.5f;
                            fireList.push_back(new Fire(spos,secondaryWeaponFireText,fireVel,FIRE_LIFE_TIME));
                            spos.y -= 1.5f;spos.x  += 1.5f;
                            fireList.push_back(new Fire(spos,secondaryWeaponFireText,fireVel,FIRE_LIFE_TIME));
                            spos.y -= 1.5f;spos.x -= 1.5f;
                            fireList.push_back(new Fire(spos,secondaryWeaponFireText,fireVel,FIRE_LIFE_TIME));

                            audios->Play(1);	
                            --secondaryWeapon[activeWeapon].counter;
                            if (secondaryWeapon[activeWeapon].counter==0){
                                secondaryWeapon[activeWeapon].active =false;
                                SetActiveSecondaryWeapon();
                            }
                            break;
                        }
                        case DEATH_LINE_FIRE:{
                            Vec3d spos = ship->position;
                            Vec3d fireVel = {0.5f,0,0};
                            
                            spos.y += 3.0f;
                                
                            for (int i=0;i<5;++i){
                                fireList.push_back(new Fire(spos,secondaryWeaponFireText,fireVel,500,DEATH_LINE_FIRE));
                                spos.y -= 1.5f;                                
                            }

                            audios->Play(1);	
                            --secondaryWeapon[activeWeapon].counter;
                            if (secondaryWeapon[activeWeapon].counter==0){
                                secondaryWeapon[activeWeapon].active =false;
                                SetActiveSecondaryWeapon();
                            }
                            break;
                        }
                        case CIRCLE_FIRE:{
                            Vec3d spos = ship->position;
                            for (int i=0;i<80;++i){
                                Vec3d fireVel = { sin((2*M_PI)/80*i),cos((2*M_PI)/80*i),0};                        
                                fireList.push_back(new Fire(spos,secondaryWeaponFireText,fireVel,FIRE_LIFE_TIME,CIRCLE_FIRE));
                            }                        
                            audios->Play(1);	
                            --secondaryWeapon[activeWeapon].counter;
                            if (secondaryWeapon[activeWeapon].counter==0){
                                secondaryWeapon[activeWeapon].active =false;
                                SetActiveSecondaryWeapon();
                            }
                            break;       
                        }


                    }

            
                }
                break;

            }

            //Silah degisimi 
            case SDLK_TAB:
                SetActiveSecondaryWeapon();
                break;            
        
        }
        

    }

    
}

void keyReleased(SDLKey sym) {
	
    switch (sym) {
			
        case SDLK_UP:
        case SDLK_KP8:
            ukey = false;
            break;
	
        case SDLK_DOWN:
        case SDLK_KP5:
            dkey = false;
            break;
	
        case SDLK_LEFT:
        case SDLK_KP4:
            lkey = false;
            break;
	
        case SDLK_RIGHT:
        case SDLK_KP6:
            rkey = false;
            break;

    }
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

//Oyun basinda yapilan tanimlama ilemleri
void initObjects(){
	
    int		i;
    Vec3d	pos;
    Meteor	*m;	
	
    activeWeapon =(enumWeaponType) -1;
    weaponBonusCounter=0;

    for (i=0;i<SECONDARY_WEAPON_COUNT;++i){
        secondaryWeapon[i].active =false;
        secondaryWeapon[i].counter =0;
        secondaryWeapon[i].type = (enumWeaponType) i;
    }    

    pos.x =-20; pos.y = 0  ; pos.z = 1  ;
	
    meteorInTheScene=10;	
    playingTime=0;
    
    for (int k=0;k<maxMeteorBonus;++k){
        bonusCome[k].come=false;
        bonusCome[k].passive=false;
    }				

    //eer daha nce tanmlandlarsa onlar silelim
    if (ship	!=NULL) ship=NULL;
    if (screen	!=NULL) screen=NULL;
    if (sky		!=NULL) sky=NULL;

		
    meteorList.clear();
    enemyList.clear();
    fireList.clear();
    explosionInfoList.clear();
    enemyFireList.clear();
    weaponBonusList.clear();

    for (i=0 ;i<maxMeteorBonus;++i){
        delete bonus[i];
        bonus[i]=NULL;
    }
    for (i=0 ;i<maxMeteorBonus;++i){
        delete bonusCome[i].bonusMeteor;
        bonusCome[i].bonusMeteor=NULL;
    }

    //gemi tanmlanmas
    ship=new Ship(pos,shipTex,expText);

    //ekran grntsnn tanmlanmas
    screen=new Screen(back1,borderText,secondaryWeapon);
		
    //kayan yldzlarn tanmlanmas
    sky = new Sky(60);
	
    srand((unsigned)time(NULL));
	
    for (i=0 ;i<meteorInTheScene;++i)
        CreateMeteor();
	
    //bonuslu dmanlarn tanmlanmas
    for (i=0; i<maxMeteorBonus;++i){
        m=new Meteor();
        m->setMeteorBonus(true); 
	    	
        //Dmann ekline gre yklenmesi gereken sprite tr belirleniyor
        switch (m->shape){
            case 0:
                m->setMeteorSprites(meteorSprite1,32);
                break;
            case 1:
                m->setMeteorSprites(meteorSprite2,32);
                break;
            case 2:
                m->setMeteorSprites(meteorSprite3,32);
                break;
        }

        bonusCome[i].bonusMeteor = m;		

    }
	
    //enemylerin tanimlanmasi
    for (i=0;i<maxEnemy;++i)
        CreateEnemy();	
	

}

//Oyun giriinde yaplmas gereken ilemler
void initApp(){
    int i;
    unsigned int tex1,tex2;	
	
    glGenTextures(1,&tex1);
    glGenTextures(2,&tex2);
    glFontCreate (&font,"courier.glf",tex1);	
	
    splash			= LoadGLTextures("TextureFiles\\splash_new.bmp",false);
    expText			= LoadGLTextures("TextureFiles\\explosion3.bmp",true);
    shipTex			= LoadGLTextures("TextureFiles\\ship.bmp",true);
    fireTex			= LoadGLTextures("TextureFiles\\shipFire.bmp",true);
    enemyFireText	= LoadGLTextures("TextureFiles\\enemyFire.bmp",true);
    enemy1			= LoadGLTextures("TextureFiles\\enemy1.bmp",true);
    enemy2			= LoadGLTextures("TextureFiles\\enemy2.bmp",true);
    enemy3			= LoadGLTextures("TextureFiles\\enemy3.bmp",true);	

    bonusOilTexture		= LoadGLTextures("TextureFiles\\exp2.bmp",true);
    bonusHealthTexture	= LoadGLTextures("TextureFiles\\exp1.bmp",true);

    secondaryWeapon[0].texture = LoadGLTextures("TextureFiles\\Weapon_Double.bmp",true);
	secondaryWeapon[1].texture = LoadGLTextures("TextureFiles\\Weapon_Triple.bmp",true);
	secondaryWeapon[2].texture = LoadGLTextures("TextureFiles\\Weapon_Death_Line.bmp",true);
	secondaryWeapon[3].texture = LoadGLTextures("TextureFiles\\Weapon_Circle.bmp",true);
	
	secondaryWeaponFireText =LoadGLTextures("TextureFiles\\SecondaryWeaponFire.bmp",true);
    borderText =LoadGLTextures("TextureFiles\\border.bmp",true);

    //Arka plan resmi ykleniyor
    back1		= LoadGLTextures("TextureFiles\\back1.bmp",false);		
	
    finText		= LoadGLTextures("TextureFiles\\finish.bmp",false);
    congText	= LoadGLTextures("TextureFiles\\congratulation.bmp",false);	
	
    pauseText	= LoadGLTextures("TextureFiles\\pause.bmp",true);	

    //Menude kullanilacak olan texture dosyalari ykleniyor
    menuStartActive		= LoadGLTextures("MenuTextures\\StartActive.bmp",true);	
    menuStartPassive	= LoadGLTextures("MenuTextures\\StartPassive.bmp",true);
    menuControlsActive	= LoadGLTextures("MenuTextures\\ControlsActive.bmp",true);
    menuControlsPassive = LoadGLTextures("MenuTextures\\ControlsPassive.bmp",true);
    menuExitActive		= LoadGLTextures("MenuTextures\\ExitActive.bmp",true);
    menuExitPassive		= LoadGLTextures("MenuTextures\\ExitPassive.bmp",true);

	
    audios = new Audio();

    audios->setAudioFiles (1,"AudioFiles\\phaser.wav");
    audios->setAudioFiles (2,"AudioFiles\\explode.wav");
    audios->setAudioFiles (3,"AudioFiles\\shipexplode.wav");
    audios->setAudioFiles (4,"AudioFiles\\complete.wav");
	
    audios->initializeAudios();
	

    char	strFileName[50];

    //Gktaslarinin spritelari ykleniyor.
    for (i=0;i<32;++i){
        sprintf ( strFileName, "SpriteFiles\\rock1_bmp\\rock%d.bmp", i+1 );
        meteorSprite1[i] = LoadGLTextures(strFileName,true);				
    }	
    for (i=0;i<32;++i){
        sprintf ( strFileName, "SpriteFiles\\rock2_bmp\\rock%d.bmp", i+1 );
        meteorSprite2[i] = LoadGLTextures(strFileName,true);		
    }	
    for (i=0;i<32;++i){
        sprintf ( strFileName, "SpriteFiles\\rock3_bmp\\rock%d.bmp", i+1 );
        meteorSprite3[i] = LoadGLTextures(strFileName,true);		
    }		
	
    for (i=0;i<11;++i){
        sprintf ( strFileName, "SpriteFiles\\OilBonusSprites\\oil%d.bmp", i+1 );
        oilBonusSprite[i] = LoadGLTextures(strFileName,true);	
    }		
	
    for (i=0;i<11;++i){
        sprintf ( strFileName, "SpriteFiles\\HealthBonusSprites\\health%d.bmp", i+1 );
        healthBonusSprite[i] = LoadGLTextures(strFileName,true);	
    }		
    
    initObjects();
	
}

//Oyun knda yaplmas gereken ilemler
void endApp() {	
   
    int i;
   
    meteorList.clear();
    enemyList.clear();
    fireList.clear();
    explosionInfoList.clear();
    enemyFireList.clear();

    for (i=0 ;i<maxMeteorBonus;++i){
        delete bonus[i];
        bonus[i]=NULL;
    }
	
    for (i=0 ;i<maxMeteorBonus;++i){
        delete bonusCome[i].bonusMeteor;
        bonusCome[i].bonusMeteor=NULL;
    }	
	
    delete audios;
    delete ship;
    delete sky;
    delete screen;
	
    printf("hibbit :)\n ");	
    glFontDestroy(&font);

}
