//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "framework.h"

#include <list>

SDL_Surface *sdlSurface;

void exitSDL() {
    endApp();
    SDL_Quit();
}

void initSDL(int width,int height,int bpp) {

    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0) {
        fprintf(stderr,"SDL baslatiminda hata! %s",SDL_GetError());
        exit(-1);
    }
    atexit(exitSDL);

    sdlSurface = SDL_SetVideoMode(width,height,bpp,SDL_OPENGL );//| SDL_FULLSCREEN);
	
    if ( sdlSurface == NULL) {
        fprintf(stderr,"SDL penceresi ailamadi!");
        exit(-1);
    }

}

void setupOpenGL(int width,int height) {
   
    glDepthFunc(GL_LESS);
    glDisable(GL_DEPTH_TEST);
    glShadeModel(GL_SMOOTH);
    glEnable(GL_NORMALIZE);
    glEnable(GL_CULL_FACE);
    glFrontFace(GL_CCW);
    glClearColor(0,0,0,0);
    glEnable(GL_TEXTURE_2D);						
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glEnable(GL_COLOR_MATERIAL);
   
    glViewport(0,0,width,height);
   
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45,(float)width/(float)height,0.1f,4000.0f);
    glMatrixMode(GL_MODELVIEW);
  
}

void showFPS(){

    char buf[100];
    static int framesPerSecond    = 0;
    static float lastTime         = 0.0f;
    float currentTime = SDL_GetTicks() * 0.001f;                
	
    ++framesPerSecond;

    if( currentTime - lastTime > 1.0f ){
        lastTime = currentTime;
        
        sprintf(buf, "Space Fire FPS: %d", framesPerSecond);

        SDL_WM_SetCaption(buf,0);
        framesPerSecond = 0;
    }

}

int main(int argc,char *argv[]) {

    bool quit = false;
    bool pause= false;
    bool fullScreen =false;

    int deathCounter=0;
	
    int finishType =0;

    bool menuScreen=true;
    bool controlsScreen=false;
    bool finishScreen=false;
	
    initSDL(800,600,32);
    setupOpenGL(800,600);
    initApp();

    while (!quit) {
				
        showFPS();
		
        if (menuScreen){
			
            switch (renderMenu()){
			
				case 1:
					menuScreen = false;
					controlsScreen=false;
					break;
				case 2:
					menuScreen = false;	
					controlsScreen=true;
					break;
				case 3:
					finishScreen=true;
					menuScreen=false;
					finishType = 2;
					break;
			}

		}
		else if (controlsScreen){		
			renderControls();
		}
		else if (finishScreen){		
 			renderFinish(finishType);					
		}
		else{
			switch (renderScene(deathCounter,pause)){		
					
				case 0:
					break;
				case 1:					
                    menuScreen = true;
                    point=0; 
					initObjects();
                    break;
			}
		}
		
		SDL_Event event;
		while (SDL_PollEvent(&event)) {
			
			switch (event.type) {
        
			case SDL_KEYDOWN:
				if (event.key.keysym.sym == SDLK_ESCAPE){
					
               if (!controlsScreen){
						quit = true;
               }
					else{
						controlsScreen=false;
						menuScreen=true;
					}

				}
                else if (event.key.keysym.sym == SDLK_SPACE || event.key.keysym.sym == SDLK_q){
					
					if (!menuScreen && !controlsScreen && !finishScreen)
						keyPressed(event.key.keysym.sym);

				}
                else if (event.key.keysym.sym == SDLK_RETURN){
					
					if (menuScreen)
						keyPressed(event.key.keysym.sym);

				}
				else if (event.key.keysym.sym == SDLK_TAB){

                    if (!menuScreen && !controlsScreen && !finishScreen)
						keyPressed(event.key.keysym.sym);

				}
				else if (event.key.keysym.sym == SDLK_p){
					
					if (!menuScreen && !controlsScreen && !finishScreen){
                        pause = !pause;						
					}

				}
             	else if (event.key.keysym.sym == SDLK_w){
					
                    if (!menuScreen && !controlsScreen && !finishScreen)
						keyPressed(event.key.keysym.sym);

				}
             	else
					if (!controlsScreen)
						keyPressed(event.key.keysym.sym);					
				
				break;

			case SDL_KEYUP:
			   keyReleased(event.key.keysym.sym);
			   break;

			case SDL_QUIT:
			   quit = true;
			}
			break;
		}
		
	}
    return 0;
}