//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Fire.h"

Fire::Fire(){
    Vec3d pos;

    pos.x=0.0f; 
    pos.y=0.0f; 
    pos.z=(float)sin(rand());

    position = pos;
    velocity.x = 0.0f;
    velocity.y = 0.0f;
    velocity.z = 0.0f;

    type = (enumWeaponType) -1;
}

Fire::Fire(Vec3d Position,unsigned int tex,Vec3d Velocity,int life,enumWeaponType type){
	
    position = Position;
    position.z+=(float)sin(rand());
	
    velocity = Velocity;
	
    fireTexture = tex;
    lifeTime = (float)life;
    this->type = type;

    explosionCreationTime =0;

}

void Fire::UpdateFire(float vel){

    //bilgisayarin hizina gre ve atesin hizina gre atesin yeni konumu ve 
    //ne kadar mr kaldigi bilgileri yenileniyor.
    explosionCreationTime += vel;
    lifeTime -= vel * 15 ;
    position.x += velocity.x * vel * 30;
    position.y += velocity.y * vel * 30;
    position.z += velocity.z * vel * 30;

} 

int Fire::RenderFire (){
	
    glPushMatrix();	
    glColor3f(1,1,1);
	
    glBlendFunc(GL_ONE, GL_ONE);
    glEnable(GL_BLEND);
	
    glBindTexture(GL_TEXTURE_2D, fireTexture);
    glEnable(GL_TEXTURE_2D);
	
    glDisable(GL_LIGHTING);	
    glBegin(GL_QUADS);
        glTexCoord2f(1.0f,1.0f); glVertex3f(position.x+0.5f,position.y+0.5f,position.z);
        glTexCoord2f(0.0f,1.0f); glVertex3f(position.x-0.5f,position.y+0.5f,position.z);
        glTexCoord2f(0.0f,0.0f); glVertex3f(position.x-0.5f,position.y-0.5f,position.z);
        glTexCoord2f(1.0f,0.0f); glVertex3f(position.x+0.5f,position.y-0.5f,position.z);
    glEnd();
    glEnable(GL_LIGHTING);	
			
    glDisable(GL_TEXTURE_2D);	
    glDisable(GL_BLEND);
	
    glPopMatrix();	

    if (position.x>MAX_X || position.y<MIN_Y+2)
        return 1;

    if (lifeTime <= 0) 
        return 1;
    
    return 0;	

}