//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Animate.h"

void    Animate::Initialize(float animVel){	
    animVelocity=animVel;
    animTimer=0;
}
	
void    Animate::PushTextureID(int textureID){
    
    listTexture.push_front (textureID);
    if (listTexture.size() == 1){
        iter = listTexture.begin();
    }

}

void	Animate::update(float deltaTime) {

    animTimer += deltaTime;
	
    if (animTimer > animVelocity) {
				
        ++iter;
		
        if (iter == listTexture.end()) 
            iter = listTexture.begin();

		animTimer=0;	
    
    }

}

int		Animate::getCurrentTexture() {
    return *iter;
}
	
void	Animate::RenderAnimation(int x,int y,float size){
	
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);	

    glBindTexture(GL_TEXTURE_2D, *iter);
    glEnable(GL_TEXTURE_2D);		
	
    glDisable(GL_LIGHTING);				
    glPushMatrix();		
        glBegin(GL_QUADS);
            glTexCoord2f(1.0f,1.0f); glVertex3f(x+size/2,y+size/2,1.0f);
            glTexCoord2f(0.0f,1.0f); glVertex3f(x-size/2,y+size/2,1.0f);
            glTexCoord2f(0.0f,0.0f); glVertex3f(x-size/2,y-size/2,1.0f);
            glTexCoord2f(1.0f,0.0f); glVertex3f(x+size/2,y-size/2,1.0f);
        glEnd();
    glPopMatrix();
    glEnable(GL_LIGHTING);				
	
    glDisable(GL_TEXTURE_2D);		
    glDisable(GL_BLEND);
}