//********************************************************************************************\/
//                             SPACE FIRE v1.3                                                \/
//                                                                                            \/ 
//     Neslihan Bagci Aydinoglu :: 2004                                                       \/   
//     www.oyunyapimi.org iin gelistirilmistir..                                             \/
//
//     lisans: lisans.txt dosyasina bakiniz.
//                                                                                            \/ 
//********************************************************************************************\/


#include "Bonus.h"

Bonus::Bonus(Vec3d pos){
    position    = pos;
    OilBonus    = false;
    HealthBonus = false;
    DoubleWeaponBonus = false;
    TripleWeaponBonus = false;
    DeathLineWeaponBonus = false;
    CircleWeaponBonus = false;
}

void Bonus::setBonusAsOil(){
    OilBonus=true;
}

void Bonus::setBonusAsHealth(){
    HealthBonus=true;
}

void Bonus::setBonusAsDoubleWeapon(){
    DoubleWeaponBonus=true;
}

void Bonus::setBonusAsTripleWeapon(){
    TripleWeaponBonus=true;
}

void Bonus::setBonusAsDeathLineWeapon(){
   DeathLineWeaponBonus=true;
}

void Bonus::setBonusAsCircleWeapon(){
    CircleWeaponBonus=true;
}

void Bonus::RenderBonus(float deltaTime){

    glPushMatrix();	

        glNormal3f(0.0f,0.0f,1.0f);
        glColor3f(1.0f,1.0f,1.0f);
        
        glTranslatef(position.x -=deltaTime ,position.y ,position.z);		
		
        bonusAnimation.update ( deltaTime );		
        bonusAnimation.RenderAnimation(0,0,2);		
		
    glPopMatrix();	


}


void Bonus::setBonusSprites(unsigned int *sprites,int size){
	
    for (int i=0;i<size;i++){
        bonusAnimation.PushTextureID(sprites[i]);				
    }
    bonusAnimation.Initialize(ANIMATE_VELOCITY);	

}