/*
 * Lib3d Ornekleri -- 1
 *
 *
 * Konu:
 *    Arazi goruntuleme, animasyonlu model gosterme,
 *    tusa basilmalarin alinmasi ve model hareketinin saglanmasi
 *
 * Kullanilan Siniflar:
 *    Terrain, AnimatedModel, SimpleTimer, Camera, Vector3d
 *
 *
 *    :: Deniz Aydinoglu    :: 2002 ::
 *    :: www.oyunyapimi.org :: 2002 ::
 */


#include "init.h"

void exitSDL() {
   endApp();
   SDL_Quit();
}

void initSDL(int width,int height,int bpp) {


   if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0) {
      fprintf(stderr,"SDL baslatiminda hata! %s",SDL_GetError());
      exit(-1);
   }

   atexit(exitSDL);

   if (SDL_SetVideoMode(width,height,bpp,SDL_OPENGL) == NULL) {
      fprintf(stderr,"SDL ekrani aamadi!");
      exit(-1);
   }

}

void setupOpenGL(int width,int height) {
   
   glDepthFunc(GL_LESS);
   glEnable(GL_DEPTH_TEST);
   glShadeModel(GL_SMOOTH);
   glClearColor(0,0,0,0);
   glViewport(0,0,width,height);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(45,(float)width/(float)height,0.1f,4000.0f);
   glMatrixMode(GL_MODELVIEW);

}

int main(int argc,char *argv[]) {

   bool quit = false;

   initSDL(640,480,16);
   setupOpenGL(640,480);
   initLib3d();
   initApp();

   while (!quit) {

      renderScene();
      
      SDL_Event event;
      while (SDL_PollEvent(&event)) {

         switch (event.type) {
         
            case SDL_KEYDOWN:
               if (event.key.keysym.sym == SDLK_ESCAPE)
                  quit = true;
               else
                  keyPressed(event.key.keysym.sym);
               break;

            case SDL_KEYUP:
               keyReleased(event.key.keysym.sym);
               break;

            case SDL_QUIT:
               quit = true;

         }
      }

   }
   
   return 0;
}
