/*
	OpenAL Dersi: OpenAL Ders 4.: 3B Ortamda Ses
	Dersin bulunduu adres: http://www.oyunyapimi.org
	Dersin Sahibi: MD.C (md.c@mynet.com)
	Yazm Tarihi: 14.Mys.2004

	Artk OpenAL' 3B ortamda kullanma vaktimiz geldi, bu ders ile OpenAL'n 3B ortamda
	nasl kullanldn reniceksiniz.
*/

/*
	Not: // Pas... ile balayan fonksiyonlar geebilirsiniz.
	Bu uygulamay en iyi ekilde anlamak iin kendinize gre deiiklikler yapn ve
	deneme / yanmla metodu ile dersi pekitirin

	*Yabanci kaynaklarla problem yaamamak iin, ingilizce terimlere ve tanmlamalara devam..

	Bu derste OpenAL ktphaneleri, Project -> Settings -> Link -> Object / Library modules
	ksmna girilen deerle uygulamaya dahil edilmitir...
 */
#define WIN32_LEAN_AND_MEAN
#define VC_LEANMEAN

#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glaux.h>
// Uygulamada gsterilecek arabann balk dosyalar
#include "Hiiinnn.h"
// OpenAL balk dosyalar
#include <al/al.h>
#include <al/alut.h>

// Ses Verisinin Tutan Nesne.
ALuint SoundBuffer;
// Ses Kayna.
ALuint Source;
// Ses Dosyasnn boyutu ve frekans aral.
ALsizei size, frequency;
// Sabit Diskten yklenecek ses dosyasnn balang adresini tutacak nesne.
ALvoid *data;
// Saniye bana decek byte' tutacak nesne.
ALenum format;
// Ses dosyasnn tekrar zelliini tutacak nesne
ALboolean loop;

// Ses kaynan Z ekseninde -5 deeri kadar ileri it. Bylece dinleyici ile kaynak arasnda
// -5f deerinde mesafe olutur.
//                           X     Y      Z
ALfloat SourcePosition[] = {0.0f, 0.0f,-5.0f};
ALfloat SourceVelocity[] = {0.0f, 0.0f, 0.0f};

// Bizim 3B koordinat sistemindeki pozisyonumuzdur.
//                             X     Y      Z
ALfloat ListenerPosition[] = {0.0f, 0.0f, 0.0f};
ALfloat ListenerVelocity[] = {0.0f, 0.0f, 0.0f};
// Dinleyicinin Konumu
//                               xPos  yPos  zPos  xUp   yUp   zUp
ALfloat ListenerOrientation[] = {0.0f, 0.0f,-1.0f, 0.0f, 1.0f, 0.0f};

// OpenAL iin hazrlk yapacak fonksiyonun prototipi
bool InitializeAL();

// OpenGL ve OpenAL'da hareketimizi tutacak nesne (z Ekseninde)
float zPos = -5.0f;

// Pas..: OpenGL ile ilgili fonksiyonlar prototipi
void RenderScene();
bool InitializeGL();
void DrawSphere();


// Bizle bir alakas yok (Biraz acaip oldu? Bu olmasa Grnt olmaz vs. vs. vs.)
void SetupPixelFormat(HDC hDC);
// Pas...
HDC g_HDC;

// Pas...
void SetupPixelFormat(HDC hDC)
{
   int nPixelFormat;

   static PIXELFORMATDESCRIPTOR pfd = {
         sizeof(PIXELFORMATDESCRIPTOR),
         1,
         PFD_DRAW_TO_WINDOW |
         PFD_SUPPORT_OPENGL |
         PFD_DOUBLEBUFFER,
         PFD_TYPE_RGBA,
         16,
         0, 0, 0, 0, 0, 0,
         0,
         0,
         0,
         0, 0, 0, 0,
         16,
         0,
         0,
         PFD_MAIN_PLANE,
         0,
         0, 0, 0 };

   nPixelFormat = ChoosePixelFormat(hDC, &pfd);

   SetPixelFormat(hDC, nPixelFormat, &pfd);
}
// Pas...
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   static HGLRC hRC;
   static HDC hDC;
   int width, height;

   switch(message)
      {
         case WM_CREATE:
            hDC = GetDC(hwnd);
            g_HDC = hDC;
            SetupPixelFormat(hDC);

            hRC = wglCreateContext(hDC);
            wglMakeCurrent(hDC, hRC);
            return 0;
            break;

         case WM_CLOSE:
         case WM_DESTROY:
            wglMakeCurrent(hDC, NULL);
            wglDeleteContext(hRC);

            PostQuitMessage(0);
            return 0;
            break;

         case WM_SIZE:
            height = HIWORD(lParam);
            width = LOWORD(lParam);

            if(height==0)
               {
                  height = 1;
               }

            glViewport(0, 0, width, height);
            glMatrixMode(GL_PROJECTION);
            glLoadIdentity();

            gluPerspective(45.0f, (GLfloat)width/(GLfloat)height, 0.1f, 1000.0f);

            glMatrixMode(GL_MODELVIEW);
            glLoadIdentity();

            return 0;
            break;

         default:
            break;
      }

      return (DefWindowProc(hwnd, message, wParam, lParam));
}
// Pas...
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
   MSG msg;
   WNDCLASSEX windowClass;
   HWND hwnd;

   bool isFinished;

   windowClass.cbSize = sizeof(WNDCLASSEX);
   windowClass.style = CS_HREDRAW | CS_VREDRAW;
   windowClass.lpfnWndProc = WndProc;
   windowClass.cbClsExtra = 0;
   windowClass.cbWndExtra = 0;
   windowClass.hInstance = hInstance;
   windowClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   windowClass.hCursor = LoadCursor(NULL, IDC_ARROW);
   windowClass.hbrBackground = NULL;
   windowClass.lpszMenuName = NULL;
   windowClass.lpszClassName = "OpenAL";
   windowClass.hIconSm = LoadIcon(NULL, IDI_APPLICATION);

   if(!RegisterClassEx(&windowClass))
      return 0;


   hwnd = CreateWindowEx(NULL,
                        "OpenAL",
                        "MD.C (md.c@mynet.com)",
                        WS_OVERLAPPEDWINDOW | WS_VISIBLE |
                        WS_SYSMENU | WS_CLIPCHILDREN |
                        WS_CLIPSIBLINGS,
                        100, 100,
                        400, 400,
                        NULL,
                        NULL,
                        hInstance,
                        NULL);

   if(!hwnd)
      return 0;

   ShowWindow(hwnd, SW_SHOW);
   UpdateWindow(hwnd);

   isFinished = false;

   if(!InitializeGL())
      isFinished = true;

   // Burada Uygulama altnda OpenAL iin hazrlk yapacak fonksiyonu
   // otomatik olarak balatyoruz. ve sorun kmamas sonucunda ileme devam ediyoruz...
   if(!InitializeAL())
	  isFinished = true;

   while(!isFinished)
      {
         PeekMessage(&msg, NULL, NULL, NULL, PM_REMOVE);

         if(msg.message == WM_QUIT)
            {
               isFinished = true;
            }
         else
            {

               RenderScene();

               TranslateMessage(&msg);
               DispatchMessage(&msg);
            }
      }
      return msg.wParam;
}

bool InitializeAL()
{
	// OpenAL'n hazrl iin alutInit(...) fonksiyonunu kullanyoruz
	alutInit(NULL, 0);
	// Eer hazrlk yaplamadysa, false deeri ile geri dn
	if(alGetError() != AL_NO_ERROR)
		return false;
	
	// OpenGL'de texture nesnesinin oluturulmas gibi burada da Ses nesnesini oluturuyoruz.
	alGenBuffers(1, &SoundBuffer);
	// Eer hata versa falsa ile geri dn.
	if(alGetError() != AL_NO_ERROR)
		return false;

	// Bilgisayardaki alarm.wav dosyasn ykle...
	alutLoadWAVFile("Data/alarm.wav", &format, &data, &size, &frequency, &loop);

	// Bellekteki ses verisini SoundBuffer'a yaz...
	alBufferData(SoundBuffer, format, data, size, frequency);

	// lk alnan ses verisini bellekten sil.
	alutUnloadWAV(format, data, size, frequency);

	// 1 adet Ses Kayna olutur ve adresini Source nesnesine yaz..
	alGenSources(1, &Source);
	// Eer bir hata varsa false ile geri dn
	if(alGetError() != AL_NO_ERROR)
		return false;

	// Source / Kaynak yaplandrlyor.
	alSourcei(Source, AL_BUFFER, SoundBuffer);
	alSourcei(Source, AL_LOOPING, true);
	alSourcef(Source, AL_GAIN, 1.0f);
	alSourcef(Source, AL_PITCH, 1.0f);
	alSourcefv(Source, AL_POSITION, SourcePosition);
	alSourcefv(Source, AL_VELOCITY, SourceVelocity);

	
	// Listener / dinleyici yaplandrlyor.
	alListenerfv(AL_POSITION, ListenerPosition);
	alListenerfv(AL_VELOCITY, ListenerVelocity);
	alListenerfv(AL_ORIENTATION, ListenerOrientation);

	// Uygulama alt anda Source nesnesini altr ve ses dosyasn almaya bala.
	alSourcePlay(Source);

	// Herey tamamsa true ile geri dn
	return true;
}

// OpenGL iin:
bool InitializeGL()
{
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	LoadGLTextures();
   return true;
}

// izim Penceresi: OpenAL & OpenGL
void RenderScene()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glTranslatef(0.0f, 0.0f, zPos);

	// leri yn tuuna basldnda zPos nesnesinin, deerini 0.04f kadar artr.
	// Artma sonunda SourcePosition Dizi (Array) nesnesinin Son basamn yani Z deerini
	// zPos deerine eitle...
	// Ses kaynana yakla
	if(GetKeyState(VK_UP) & 0x80)
	{
		zPos += 0.04f;
		SourcePosition[2] = zPos;
	}

	// Geri yn tuuna basldnda zPos'un deerini 0.04f kadar eksilt ve SourcePosition
	// Dizi nesnesinin son basamana eitle...
	// Ses kaynandan uzakla
	if(GetKeyState(VK_DOWN) & 0x80)
	{
		zPos -= 0.04f;
		SourcePosition[2] = zPos;
	}

	// Yaplan ilemleri OpenAL'a gir ve akm gncelle.
	alSourcefv(Source, AL_POSITION, SourcePosition);

	// Uygulamada kullanlacak arabay iz
	DrawCar();

	// Pas...
	SwapBuffers(g_HDC);
}
