/*
	OpenAL Dersi: OpenAL Ders 1.: OpenAL'a Giri
	Dersin bulunduu adres: http://www.oyunyapimi.org
	Dersin Sahibi: MD.C (md.c@mynet.com)
	Yazm Tarihi: 14.Mys.2004

	Bu Dersde, uygulama konsol tabanldr. Bylece daha sade bir ortamda
	OpenAL' en iyi ekilde renme imkanna sahipsiniz. lerleyen derslerde, Win32 ile
	OpenGL kullanarak Devam edeceiz...
*/

/*
	Not: ALint, ALfloat ve ALenum vs. gibi tanmlamalar sras ile int, float ve enum
	veri trlerini tekil eder. Bunlar bu ekilde kullanmanz, tahsis edeceimiz
	nesnelerin ses sisteminde kullanlacan ve OpenAL'a ait olduklarn simgeler,
	bylece okunabilirlik artar... Bende OpenAL derslerimde bu tanmlamar kullanacam.

	*leride ingilizce kaynaklardan yararlanabilmeniz iin derslerdeki uygulamalarda 
	yorumlar dnda herey ingilizce olacak...
 */
#include <iostream>
#include <AL/al.h>   // OpenAL'n tum fonksiyon protiplerinin bildirildii
                     // balk dosyasdr... Doal olarak OpenAL ktphanesini
                     // kullabilmek iin bu dosyay projenize dahil etmemiz art.

#include <AL/alut.h> // Yazlm gelitiricisinin iini kolaylatracak fonksiyonlarn
                     // bildirildii balk dosyas.
using namespace std;

// Aadaki iki satr ile, OpenAL'n ktphanelerini projemize dahil ediyoruz
// Ayn ilemi Microsoft Visual Studio da, Project (men) -> Settings... (men) ->
// Link (sekme) -> Object/Library Modules (Yaz kutusu) ksmna gireceiniz
// OpenAL32.lib ve Alut.lib deerleri ile yapabilirsiniz.
// Aada comment'n ikinci parametresinde olan satrlar (dizinler) sizde farkl olabilir,
// herhangi bir hata durumunda bu parametreleri kendi sisteminize gre uyarlayn
#pragma comment(lib, "C:\\Program Files\\Microsoft Visual Studio\\Vc98\\Lib\\OpenAL32.lib")
#pragma comment(lib, "C:\\Program Files\\Microsoft Visual Studio\\Vc98\\Lib\\ALut.lib")

// SoundBuffer, Bellee alnacak ses verisini tutar, SoundBuffer iin Adaki Ana Bilgisayar
// benzetmesi yaplabilir
ALuint SoundBuffer;
// Source de; bir Adaki istemci diyebiliriz. Tabiki ada bir sr istemci olabilir...
// yani Source; 3B dnya geometrisinde yer alan ses kaynadr
ALuint Source;

// ALsize tamyas trdr. size nesnesi ise; ses dosyasnn buyutunu tutacak nesnedir.
// frequency nesnesi; ses dosyasnn frekans araln tutacak
ALsizei size, frequency;

// ALvoid void iareti trdr. data nesnesi; sabit disk yada trevi bir donanmdan, bellee
// yklenecek ses dosyasnn bellekteki balang adresini gsterir
ALvoid *data;
// format nesnesi; saniye bana den byte deerini tutacak.
// Mono ve Sterio kavramlar bu nesneyle ilikilidir.
ALenum format;
// loop nesnesi; Ses dosyasnn tekrar zelliinin karln, true yada false olarak tutacak.
ALboolean loop;

// SourcePosition Dizi nesnesi; ses kaynann 3B koordinat sisteminde ki konumudur
//                           X     Y      Z
ALfloat SourcePosition[] = {0.0f, 0.0f, 0.0f};
// SourceVelocity Dizi nesnesi; sesin yaylma hacmi ve hzn berlirtir.
ALfloat SourceVelocity[] = {0.0f, 0.0f, 0.0f};

// ListenerPosition Dizi nesnesi; dinleyicinin, yani bizim 3B koordinat sistemindeki pozisyonumuzdur.
//                             X     Y      Z
ALfloat ListenerPosition[] = {0.0f, 0.0f, 0.0f};
// ListenerVeocity Dizi nesnesi; Dizi nesnesi; SourceVelocity ile ayn vazifededir..
ALfloat ListenerVelocity[] = {0.0f, 0.0f, 0.0f};
// Aadaki nesne OpenGL'de gluLookAt(...) fonksiyonunun mantna benzetebiliriz.
//                               xPos  yPos  zPos  xUp   yUp   zUp
ALfloat ListenerOrientation[] = {0.0f, 0.0f,-1.0f, 0.0f, 1.0f, 0.0f};

// OpenAL iin hazrlklarn yapld fonksiyon.
bool OpenALInit()
{
	// OpenAL'n hazrl iin alutInit(...) fonksiyonunu kullanyoruz
	alutInit(NULL, 0);
	// Eer hazrlk yaplamadysa, false deeri ile geri dn
	if(alGetError() != AL_NO_ERROR)
		return false;
	
	// OpenGL'de texture nesnesinin oluturulmas gibi burada da Ses nesnesini oluturuyoruz.
	alGenBuffers(1, &SoundBuffer);
	// Eer hata versa falsa ile geri dn.
	if(alGetError() != AL_NO_ERROR)
		return false;

	// Bu fonksiyon ile sabit disteki ses verisini, data nesnesinin bellekte gsterecei
	// yere aktaryoruz.
	// alutLoadWAVFile() 'n ilk parametresi ses dosyasnn addr, ikinci parametresi;
	// saniye bana decek byte bilgisidir, nc parametresi; ses verisinin bellekte
	// bulundu yerin ilk adresidir. drdnc parametresi; ses dosyasnn boyutudur,
	// beinci parametresi; ses dosyasnn frekans araldr ve son parametresi ses dosyasnn
	// tekrarlama deeridir.
	// Nesnelerin bana '&' operatrn ekleyerek, ses dosyasndan alnan bilgileri
	// uygun nesnelere yazyoruz.
	alutLoadWAVFile("Data/ciptiz_ciptiz.wav", &format, &data, &size, &frequency, &loop);

	// Bellee yklediimiz ses verisini format, data, size, frequency gibi deerler ile
	// SoundBuffere nesnesine aktaryoruz.
	// Bunun sebebini Dosyas indirdiiniz sayfadaki yazda bulabilirsiniz...
	alBufferData(SoundBuffer, format, data, size, frequency);

	// data pointerinin gsterdii yerde bulunan ve sabit diskten yklediimiz ses dosyasn
	// artk bellekten siliyoruz.
	// Bunun sebebini Dosyas indirdiiniz sayfadaki yazda bulabilirsiniz...
	alutUnloadWAV(format, data, size, frequency);

	// SoundBuffer da barnan ses dosyasn, kullanacak ses kaynaklarn oluturuyoruz.
	// ileride birden fazla kaynak oluturmay greceiz...
	alGenSources(1, &Source);
	// Eer bir hata varsa false ile geri dn
	if(alGetError() != AL_NO_ERROR)
		return false;

	// Source nesnesinin (ses kaynann) SoundBuffer'da bulunan ses verisini nasl kullanacan
	// aadaki satrlarda belirliyoruz...
	// lk satr nemli burada Hafzada bulunan ses verisinin adresini, Source nesnesine bildiriyoruz.
	alSourcei(Source, AL_BUFFER, SoundBuffer);
	alSourcei(Source, AL_LOOPING, loop);
	alSourcef(Source, AL_GAIN, 1.0f);
	alSourcef(Source, AL_PITCH, 1.0f);
	alSourcefv(Source, AL_POSITION, SourcePosition);
	alSourcefv(Source, AL_VELOCITY, SourceVelocity);
	
	// Listener yani dinleyicinin ald deerler.
	alListenerfv(AL_POSITION, ListenerPosition);
	alListenerfv(AL_VELOCITY, ListenerVelocity);
	alListenerfv(AL_ORIENTATION, ListenerOrientation);

	// Herey tamamsa true ile geri dn
	return true;
}

bool main()
{
	cout << "Ses dosyasi Yukleniyor...\n";
	// OpenALInit() altrarak ortam hazrlanyor...
	if(OpenALInit() == false)
		cout << "olmadi\n";

	// Sorun yoksa... Konsoldaki "Ses dosyasi Yukleniyor" yazsn sil
	system("cls");

	cout << "Ses dosyasini calistirmak icin; 'C', Durdurmak icin; 'D', Ara vermek icin;\n'A' harfini girin\n";
	cout << "Cikmak icin; 'K' harfini girin\n";
	char istek = 0;

	while(true)
	{
		cout << "Girdi: ";
		cin >> istek;

		if(istek == 'C' || istek == 'c')
			// alSourcePlay(...) ile Source nesnesini (ses kaynan) altryoruz
			alSourcePlay(Source);

		if(istek == 'D' || istek == 'd')
			// Source nesnesinin alamasna son ver.
			alSourceStop(Source);

		if(istek == 'A' || istek == 'a')
			// Source nesnesini duraklat
			alSourcePause(Source);

		if(istek == 'K' || istek == 'k')
			return false;
	}
	return false;
}