/*
	Oyunyapimi.org "Particle Engine 2" adli yazi ile ilgili ornek kodlar.

	Hicbir copyright, copyleft yok. Istediginiz sekilde kodu degistirebilir veya 
	aynen kullanabilirsiniz.

	Saygilar, mentat...
	Kasim 2003
*/


#include "smokesystem.h"
#include "TextureManager.h"

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

#define RandFloat ((float)(rand()%1001)/1000.0f)

using namespace XParticle;
using namespace XSceneGraph;
SmokeSystem::SmokeSystem(const std::string& texName) : m_texName(texName)
{
}

SmokeSystem::~SmokeSystem(void)
{
}

void SmokeSystem::initialize()
{
	int m_size = 10;
	m_particles.reserve(m_size*100);
	emit(m_size);
}

void SmokeSystem::render() const
{
	const ITexture* pTexture = TextureManager::getInstance()->getTexture(m_texName);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_DEPTH_TEST);
	
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
	glEnable (GL_BLEND);
	glBindTexture(GL_TEXTURE_2D, pTexture->getTextureID());

	std::vector<Particle*>::const_iterator it = m_particles.begin();
	while(m_particles.end() != it)
	{
		Particle p(**it);
		glBegin(GL_TRIANGLE_STRIP);				// Build Quad From A Triangle Strip
			glTexCoord2d(1,1); 
			glVertex3f(p.getPos().x+p.getHalfSize(), p.getPos().y+p.getHalfSize(), p.getPos().z); // Top Right
			glTexCoord2d(0,1); 
			glVertex3f(p.getPos().x-p.getHalfSize(), p.getPos().y+p.getHalfSize(), p.getPos().z); // Top Left
			glTexCoord2d(1,0); 
			glVertex3f(p.getPos().x+p.getHalfSize(), p.getPos().y-p.getHalfSize(), p.getPos().z); // Bottom Right
			glTexCoord2d(0,0); 
			glVertex3f(p.getPos().x-p.getHalfSize(), p.getPos().y-p.getHalfSize(), p.getPos().z); // Bottom Left
		glEnd();
		++it;
	}

	glBindTexture(GL_TEXTURE_2D, 0);
	glEnable(GL_DEPTH_TEST);
}

void SmokeSystem::update(float time_elapsed)
{
	std::vector<Particle*>::iterator it = m_particles.begin();
	while(m_particles.end() != it)
	{
		(*it)->setPos((*it)->getPos() + (*it)->getVelocity() * time_elapsed);
		++it;
    }

	static float time_passed(0);
	time_passed += time_elapsed;
	if(time_passed > 300)
	{
		emit(1);
		time_passed = 0;
	}

}
void SmokeSystem::reset()
{
}

void SmokeSystem::setParticle(Particle& p)
{
	p.setPos(m_origin);
	p.setHalfSize(5);
	p.setVelocity(Vector3(RandFloat*0.0015f-0.00075f, 0.002f+RandFloat*0.002f, RandFloat*0.0005f-0.00025f));
}

void SmokeSystem::emit(unsigned int count)
{
	Particle* dummy(0);
	for(unsigned int i = 0; i < count; ++i)
	{
		dummy = new Particle;
		setParticle(*dummy);
		m_particles.push_back(dummy);
	}
}