/********************************************************************************
	MPEG-4 FACEPLAYER
	Copyright (C) 2003  Koray Balci
	balci 'at' itc.it
********************************************************************************/
/********************************************************************************
*																				
*	This program is free software; you can redistribute it and/or				
*	modify it under the terms of the GNU General Public License					
*	as published by the Free Software Foundation; either version 2				
*	of the License, or (at your option) any later version.						
*																				
*	This program is distributed in the hope that it will be useful,				
*	but WITHOUT ANY WARRANTY; without even the implied warranty of				
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the				
*	GNU General Public License for more details.								
*
*	You should have received a copy of the GNU General Public License			
*	along with this program; if not, write to the Free Software					
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.	
*																				
********************************************************************************/


/*! 
	\file	ITextureLoader.h
	\brief	Base class for texture loading to any API.
*/

#ifndef TEXTURELOADER_H_
#define TEXTURELOADER_H_

#include <string>

#include "ITexture.h"
/*!
	\brief	Base class for texture loading
	\ingroup XStream
	\author	Koray Balci
	\version 1.0
	\date   August 2002

	Serves as a base class for texture loading. Note that, loading a texture is an 
	API (D3D/OpenGL) dependant operation. To ensure API independence, we use this 
	pure abstract base class.
*/
	namespace XStream{

class ITextureLoader  
{
public:
	//! UnLoads a texture attached to an ITexture object.
	virtual void unLoad(const XSceneGraph::ITexture* pTexture) = 0;
	//! Loads the texture
	virtual bool load(const char* filename, XSceneGraph::ITexture* pTexture) = 0;
	//! Default constructor
	ITextureLoader(){};
	//! Destructor
	virtual ~ITextureLoader(){};
};
	}
#endif // TEXTURELOADER_H_
