/*! 
	\file	ITexture.h
	\brief	Base class for texture mapping
*/

#ifndef ITEXTURE_H_
#define ITEXTURE_H_

#include <string>

/*!
	\brief	Base class for texture mapping
	\ingroup XSceneGraph
	\author	Koray Balci
	\version 1.0 (August 2002) 
			<br>1.1 (Jan 2003)

	Serves as a base class for texture mapping. Stores the texture name and ID,
	ITexture instances are created in ITextureLoader interface and registered
	to TextureManager using TextureManager::load() member.
	
	Each instance should be named whit a unique string and registered to TextureManager
	for consistent behaviour. 

	\sa Texture2D, ITextureLoader, TextureLoaderGL, TextureManager
*/
namespace XSceneGraph{
class ITexture
{
public:
	/*!
		Enumeration for the types of textures, currently there is only one, 
		but later, we will need 1D and 3D as well perhaps.
	*/
	enum TEXTURETYPE
	{
		TEXTURE2D		//!< 2D Texture type identifier
	};

	//! Accessor for the name of the texture
	void setName(const std::string& name) {m_Name = name;};
	//! Accessor for the name of the texture
	const std::string& getName() const {return m_Name;};

	//! Returns the type of texture
	virtual TEXTURETYPE getTextureType() const = 0;
	//! Returns the texture id attached to this object
	const unsigned int getTextureID() const {return m_TexID;};
	//! Default Constructor
	ITexture() : m_TexID(0){};
	//! Destructor
	virtual ~ITexture(){};
	unsigned int m_TexID;
private:
	//friend class TextureLoaderGL; // Do we need this?
	
	std::string m_Name;
};
}
#endif // ITEXTURE_H_
