/*
	Oyunyapimi.org "Particle Engine 2" adli yazi ile ilgili ornek kodlar.

	Hicbir copyright, copyleft yok. Istediginiz sekilde kodu degistirebilir veya 
	aynen kullanabilirsiniz.

	Saygilar, mentat...
	Kasim 2003
*/


#ifndef IPARTICLESYSTEM_H_
#define IPARTICLESYSTEM_H_

#include <vector>
#include "Vector3.h"
#include "Particle.h"

namespace XParticle{
	class IParticleSystem
	{
	protected:
		std::vector<Particle*> m_particles;			// parcaciklar burada dursun
		XMath::Vector3 m_origin;					// sistemin merkezi
	public:
		virtual void reset() = 0;					// tum sistemi ilk haline dondurmek icin
		virtual void initialize() = 0;				// sistemi baslatmak icin
		virtual void render() const = 0;			// cizim
		virtual void emit(unsigned int count) = 0;			// yeni parcacik yaratmak
		virtual void update(float time_elapsed) = 0;		// parcaciklari guncellemek
		IParticleSystem(void): m_origin(Vector3(0, 0, 130)){}	// constructor
		virtual ~IParticleSystem(void) 
		{
			// parcaciklarin temizligi
			std::vector<Particle*>::iterator it = m_particles.begin();
			while (it != m_particles.end())
			{
				delete *it;
				++it;
			}
		}
	};
}
#endif // IPARTICLESYSTEM_H_