/*
	Oyunyapimi.org "Particle Engine 1" adli yazi ile ilgili ornek kodlar.

	Hicbir copyright, copyleft yok. Istediginiz sekilde kodu degistirebilir veya 
	aynen kullanabilirsiniz.

	Saygilar, mentat...
	Eylul 2003
*/

#include "XParticle.h"

#include <windows.h>
#include <GL\gl.h>


XParticle::XParticle(void)
{
	m_bAlive = true;
	m_Life = 1;

	m_Pos.x = rand()%500 - 250;
	m_Pos.y = rand()%500 - 250;
	m_Pos.z = rand()%500 - 250;

	m_Fade = float(rand()%100)/1000.0f+0.003f;

	m_Velocity.x = float((rand()%50)-26.0f)*10.0f;		// Random Speed On X Axis
	m_Velocity.y = float((rand()%50)-25.0f)*10.0f;		// Random Speed On Y Axis
	m_Velocity.z = float((rand()%50)-25.0f)*10.0f;		// Random Speed On Z Axis

}

void XParticle::Update(float elapsed_time)
{
	if(!m_bAlive)
		return;

	static const float slowdown=2.0f;			// Slow Down Particles

	m_Pos.x += m_Velocity.x/(slowdown*1000);	// Move On The X Axis By X Speed
	m_Pos.y += m_Velocity.y/(slowdown*1000);	// Move On The Y Axis By Y Speed
	m_Pos.z += m_Velocity.z/(slowdown*1000);	// Move On The Z Axis By Z Speed
}

void XParticle::Draw(void)
{
	glBegin(GL_TRIANGLE_STRIP);				// Build Quad From A Triangle Strip
		glTexCoord2d(1,1); glVertex3f(m_Pos.x+0.5f, m_Pos.y+0.5f, m_Pos.z); // Top Right
		glTexCoord2d(0,1); glVertex3f(m_Pos.x-0.5f, m_Pos.y+0.5f, m_Pos.z); // Top Left
		glTexCoord2d(1,0); glVertex3f(m_Pos.x+0.5f, m_Pos.y-0.5f, m_Pos.z); // Bottom Right
		glTexCoord2d(0,0); glVertex3f(m_Pos.x-0.5f, m_Pos.y-0.5f, m_Pos.z); // Bottom Left
	glEnd();
}
