/*
	Oyunyapimi.org "Particle Engine 1" adli yazi ile ilgili ornek kodlar.

	Hicbir copyright, copyleft yok. Istediginiz sekilde kodu degistirebilir veya 
	aynen kullanabilirsiniz.

	Saygilar, mentat...
	Eylul 2003
*/


#include "SDLTester.h"

int main(int argc, char **argv)
{
	SDLTester test;
	    
	if(test.init("test"))
	{
		while( test.processEvents() ) 
		{
			test.render();
		}
		test.quit();
	}

	return 0;
}

void SDLTester::quit()
{
	SDL_Quit( );
}

void SDLTester::resize(int width, int height)
{
	m_wndHeight = height;
	m_wndWidth	= width;
	// Setup our viewport. 
    glViewport( 0, 0, width, height );

    /*
     * Change to the projection matrix and set
     * our viewing volume.
     */
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity( );
    
	float ratio = (float) width / (float) height;
	gluPerspective( 30.0, ratio, 1.0, 1000.0 );
	glMatrixMode( GL_MODELVIEW );
}

void SDLTester::initGL(int width, int height)
{
	// Our shading model--Gouraud (smooth). 
    glShadeModel( GL_SMOOTH );

    // Culling. 
    glCullFace( GL_BACK );
    glFrontFace( GL_CCW );
    glEnable( GL_CULL_FACE );

    // Set the clear color. 
	glClearColor(0.5f, 0.5f, 0.5f, 1.0f); //Background color

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);

	resize(width, height);
}

bool SDLTester::onKeyDown( SDL_keysym* keysym)
{
    switch( keysym->sym ) 
	{
		case SDLK_ESCAPE:
		    return false;
			break;
		case SDLK_SPACE:
			break;
		default:
			break;
    }
	return true;
}

void SDLTester::onMouseButton(short button, int x, int y, short state)
{
/*	if( button == SDL_BUTTON_LEFT)
	{
		if (state == SDL_PRESSED)
		{
		}
		else if(state == SDL_RELEASED)
		{
		}	
	}
	else if (button == SDL_BUTTON_RIGHT)
	{
	}
*/
}
bool SDLTester::processEvents()
{
	// Our SDL event placeholder.
    SDL_Event event;

    // Grab all the events off the queue.
    while( SDL_PollEvent( &event ) ) 
	{
        switch( event.type ) 
		{
		case SDL_VIDEORESIZE:
			resize(event.resize.w, event.resize.h);
			break;
        case SDL_KEYDOWN:
            // Handle key presses. 
            return onKeyDown( &event.key.keysym );
            break;
		case SDL_MOUSEBUTTONDOWN:
		case SDL_MOUSEBUTTONUP:
			onMouseButton(event.button.button, event.button.x, event.button.y, event.button.state);
			break;
        case SDL_QUIT:
            // Handle quit requests (like Ctrl-c). 
			return false;
            break;
        }
    }
	return true;
}


bool SDLTester::init(const std::string& filename)
{
	// First, initialize SDL's video subsystem. 
    if( SDL_Init( SDL_INIT_VIDEO ) < 0 ) 
	{
        // Failed, exit. 
        fprintf( stderr, "Video initialization failed: %s\n", SDL_GetError( ) );
        quit();
		return false;
    }

    // Let's get some video information. 
    // Information about the current video settings. 
    const SDL_VideoInfo* info = SDL_GetVideoInfo();

    if( !info ) 
	{
        fprintf( stderr, "Video query failed: %s\n", SDL_GetError( ) );
        quit();
		return false;
    }

    int flags = 0;	// Flags we will pass into SDL_SetVideoMode. 
	int width = 640;
    int height = 480;
    int bpp = info->vfmt->BitsPerPixel;

    /*
     * Now, we want to setup our requested
     * window attributes for our OpenGL window.
     * We want *at least* 5 bits of red, green
     * and blue. We also want at least a 16-bit
     * depth buffer.
     *
     * The last thing we do is request a double
     * buffered window. '1' turns on double
     * buffering, '0' turns it off.
     *
     * Note that we do not use SDL_DOUBLEBUF in
     * the flags to SDL_SetVideoMode. That does
     * not affect the GL attribute state, only
     * the standard 2D blitting setup.
     */
	SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );

    // REMEMBER TO HANDLE RESIZING
	flags = SDL_OPENGL | SDL_RESIZABLE;

    
	// Set the video mode
    if( SDL_SetVideoMode( width, height, bpp, flags ) == 0 ) 
	{
        fprintf( stderr, "Video mode set failed: %s\n", SDL_GetError( ) );
        quit();

		return false;
    }

    /*
     * At this point, we should have a properly setup
     * double-buffered window for use with OpenGL.
     */
    initGL( width, height );

	m_particles.Create(30000);
	return true;
}

void SDLTester::showFPS()
{
	static char buf[100];
	static int framesPerSecond    = 0;           // This will store our fps
    static float lastTime         = 0.0f;        // This will hold the time from the last frame
    float currentTime = SDL_GetTicks() * 0.001f;                
	++framesPerSecond;
	if( currentTime - lastTime > 1.0f )
    {
        // Here we set the lastTime to the currentTime.  This will be used as the starting point for the next second.
        // This is because GetTickCount() counts up, so we need to create a delta that subtract the current time from.
        lastTime = currentTime;
        
        // Copy the frames per second into a string to display in the window title bar
        sprintf(buf, "Oyunyapimi.org FPS: %d", framesPerSecond);

        // Set the window title bar to our string
        SDL_WM_SetCaption(buf,"Oyunyapimi.org");            // The First argument is the window title

        // Reset the frames per second
        framesPerSecond = 0;
    }
}

void SDLTester::render()
{
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

    glMatrixMode( GL_MODELVIEW );
	glPushMatrix();
		
		glLoadIdentity( );
		glTranslatef( 0.0, 0.0, -700.0 );

		m_particles.Render();
		m_particles.Update(5);
	glPopMatrix();
	SDL_GL_SwapBuffers( );
	showFPS();
}