unit edit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DXDraws, StdCtrls, DXClass, ExtCtrls;

type
  TForm1 = class(TForm)
    DXDraw1: TDXDraw;
    List1: TListBox;
    Load: TButton;
    Save: TButton;
    Tileset: TDXImageList;
    DXTimer1: TDXTimer;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure List1Click(Sender: TObject);
    procedure DXDraw1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DXTimer1Timer(Sender: TObject; LagCount: Integer);
    procedure SaveClick(Sender: TObject);
    procedure LoadClick(Sender: TObject);
  private
    tiledata : array[0..19] of array[0..19] of smallint;
    gamepath:string;
    tindex:integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var i:integer;
begin
gamepath:=extractfilepath(paramstr(0));
Tileset.Items.LoadFromFile(gamepath+'graf.dxg');


list1.Clear; //Listeyi temizle,aslnda gerek yok ama olsun...
for i:=0 to tileset.Items.Count-1 do // 0'dan tileset'teki doku saysna kadar
list1.AddItem(tileset.Items[i].Name,list1); // btn resimlerin isimleri listeye ekle

dxtimer1.Enabled :=true;
end;

procedure TForm1.List1Click(Sender: TObject);
begin
tindex:=0; //doku bilgisini 0 yap,
image1.Picture :=tileset.Items[list1.itemindex].Picture; { bir listboxta kanc eleman tkladysak o say
listbox'un ItemIndex zelliinde tutulur.biz dokular yklerken 0'dan dokusays -1'e kadar listeye eleman
eklemitik,o zaman listede adn tkladmz resmin tileset iindeki indexi de bu say olacak.}
tindex:=list1.ItemIndex; // hangi dokuyu setiimiz bilgisini saklyoruz nk haritaya izim yaparken lazm olacak.
end;
procedure TForm1.DXDraw1MouseUp(Sender: TObject; Button: TMouseButton;  Shift: TShiftState; X, Y: Integer);
Begin
//X,Y DXDraw  zerinde tkladmz noktann koordinatlarn verir.
if button= mbleft then //eer farenin sol tuuna tklanmsa
tiledata[x div 16,y div 16]:=tindex; { harita dizimizde tkladmz yere karlk gelen hcreye
u andaki doku bilgisini ekle[tindex],peki neden div 16 ifadesini kullanyoruz?
Gzel soru,div operatr x,y'nin 16'ya tam blmn verir.Bu da 320x320 bir ekranda
0-19 arasnda bir deer olacak yani dizimizin boyutlar arasnda.
Mesela ekranda x=12,y=22'ye tkladmz dnelim "12 div 16=0" ve "22 div 16=1" olacak ve tiledata[0,1]'a iaret edeceiz.
bu olay daha iyi anlamanz iin aaya u eklemeyi yaptm normalde gerekli deil,sonradan silebilirsiniz:}
caption:=inttostr(x)+' '+inttostr(y);
end;

procedure TForm1.DXTimer1Timer(Sender: TObject; LagCount: Integer);
var  h,w:integer;
begin
// burada ok zgn bir ey yok iie iki dngyle tiledata iiinde tuttuumuz btn doku bilgisiniekrana izdiriyoruz.
for h:=0 to 19 do
        for w:=0 to 19 do
        tileset.Items[tiledata[h,w]].Draw(dxdraw1.surface,h*16,w*16,0);
        //eer buraya kadar iyi takip ettiyseniz aklamaya gerek bile yok,
        //tileset.Items[] dizisinde tileset[h,w]'ye karlk gelen doku
        //numarasn(im iin 0,kum iin 1 aa iin 2) dxdraw'un surface'ine izdiriyoruz.
        // h ve w ; 0-19 arasnda deerler olduu iin 16 ile arpyoruz.
        //editr ilk altnda btn tiledata[h,w]'ler
        //0 deerine sahip olaca iin imle kapl bir ekranla karlaacaz muhtemelen.
        dxdraw1.flip;
end;

procedure TForm1.SaveClick(Sender: TObject);
var f:file of byte;
begin
assignfile(f,gamepath+'map.txt'); //oyunla ayn klasre map.txt diye bir dosya a
rewrite(f); //dosyay yazmak iin a
blockwrite(f,tiledata,20*20*2); //dosyaya 20*20(haritadaki doku says) * 2 (smallintin bellek boyutu) =800 bytelk data yaz.
closefile(f); //dosyay kapat.
end;

procedure TForm1.LoadClick(Sender: TObject);
var f:file of byte;
begin
assignfile(f,gamepath+'map.txt');
reset(f);
blockread(f,tiledata,20*20*2);
closefile(f);
//Az nceki kodun tam tersi,buyzden ek bir aklamaya gerek yok,
//burda reset'le dosyay okumak iin ap ,blockread'la dosyadan okuma yapyoruz.
end;

end.
