#ifndef _IMAGE_H
#define _IMAGE_H

#ifdef _WIN32
#include "windows.h"
#endif

#include <gl/gl.h>
#include <gl/glu.h>

#include "jpeglib.h"

struct tImage
{
	int channels;			// The channels in the image (3 = RGB : 4 = RGBA)
	int sizeX;				// The width of the image in pixels
	int sizeY;				// The height of the image in pixels
	unsigned char *data;	// The image pixel data
};

void loadTexture(unsigned int *tex_id,const char *filename);

// This loads and returns the JGP data
tImage *LoadJPG(const char *strFileName);

// This decompresses the JPEG and fills in the image data
void DecodeJPG(jpeg_decompress_struct* cinfo, tImage *pImageData);

#endif


/////////////////////////////////////////////////////////////////////////////////
//
// * QUICK NOTES * 
//
// In this file we have all of our image loading code and made it so they
// each pass back a tImage object.  We use the glaux library to load the
// bitmap like we did before in all the previous tutorials, but convert the
// data to a tImage structure which is passed back.
//
// I might note that I got rid of the tImageJPG structure out of jpeglib.h
// since we didn't need it anymore.
//
// Ben Humphrey (DigiBen)
// Game Programmer
// DigiBen@GameTutorials.com
// Co-Web Host of www.GameTutorials.com
//
//