/*
 * INTRO
 *
 * :: Deniz Aydinoglu    :: 2003 ::
 * :: www.oyunyapimi.org :: 2003 ::
 *
 */

#include "init.h"
#include "jpeg/image.h"

#include <math.h>

long     dtime;
unsigned int back_texid, particle_texid, pred_texid;
int      cube_list[2];

extern bool APP_QUIT;
bool going_to_quit=false;

void drawCube(bool drw_updown=true)
{
   glBegin(GL_QUADS);
      // Front Face
   glNormal3f( 0.0f, 0.0f, 1.0f);
   glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
   glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
   glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
   glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);

   // Back Face
   glNormal3f( 0.0f, 0.0f,-1.0f);
   glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
   glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
   glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
   glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
   // Top Face
	
   if (drw_updown) {
   
      glNormal3f( 0.0f, 1.0f, 0.0f);
      glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
      glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
      glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
      glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
      // Bottom Face
      glNormal3f( 0.0f,-1.0f, 0.0f);
      glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
      glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
      glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
      glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);

   }
	   
   // Right Face
   glNormal3f( 1.0f, 0.0f, 0.0f);
   glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
   glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
   glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
   glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
   // Left Face
   glNormal3f(-1.0f, 0.0f, 0.0f);
   glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
   glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
   glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
   glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
   glEnd();
}

void do_background(float angle) {

   const float w = 550;
   const float h = 450;
   
   glEnable(GL_TEXTURE_2D);
   glBindTexture(GL_TEXTURE_2D,back_texid);
   glBegin(GL_QUADS);
      glNormal3f(0,0,1);
      // jpeg yukleme kodu _ters_ (up<->down) texture urettigi icin
      // burada _ters_ bi texture koordinat vermem gerekti :/
      glTexCoord2f(0,1); glVertex3f(-w,-h,0);
      glTexCoord2f(0,0); glVertex3f(-w,h,0);
      glTexCoord2f(1,0); glVertex3f(w,h,0);
      glTexCoord2f(1,1); glVertex3f(w,-h,0);
   glEnd();
   glDisable(GL_TEXTURE_2D);

}

void do_effect1(float t) {

   glPushMatrix();
   glTranslatef(-180,-170,500);
  
   glEnable(GL_TEXTURE_2D);
   glBindTexture(GL_TEXTURE_2D,particle_texid);
   float sine;
   for (int i=0;i<8;++i) {
   
      
      glPushMatrix();
      glRotatef(sinf((20*i+t)*0.01f)*90,0.0f,1.0f,0.0f);
      //glColor3ub(255-i*100,193,5);
      
      sine = (sinf(20*i+t*0.1f)*7.0f)+8.0f;
      glScalef(20+sine,100+sine,20+sine);
      glCallList(cube_list[0]);
      glPopMatrix();
           
      glTranslatef(0,48,0);
   
   }
   glDisable(GL_TEXTURE_2D);
   glPopMatrix();

}

void do_effect2(float t) {

   glPushMatrix();
   glRotatef(t*0.7f,1,1,1);
   glRotatef(t*0.9f,0,1,0);
   glRotatef(t*0.5f,0,0,1);

   glEnable(GL_TEXTURE_2D);
   glBindTexture(GL_TEXTURE_2D,pred_texid);

   glMatrixMode(GL_TEXTURE);
   glPushMatrix();
   glLoadIdentity();
   glScalef(sinf(t*0.01f)+2,sinf(t*0.01f)+2,1);

   glMatrixMode(GL_MODELVIEW);
   
   glColor3f(1.0f,0.4f,0.5f);
   
   glScalef(65,65,65);
   glTranslatef(-2+sinf(t*0.01f),-2+sinf(t*0.01f)*2,2+sinf(t*0.01f)*4);
   for (int i=0;i<3;++i) {
      glTranslatef(0,0,-1);
      glPushMatrix();
      for (int j=0;j<3;++j) {
         glTranslatef(1,0,0);
         glPushMatrix();
         for (int k=0;k<3;++k) {
            glTranslatef(0,1,0);
            glCallList(cube_list[1]);
         }
         glPopMatrix();
      }
      glPopMatrix();
   }

   glMatrixMode(GL_TEXTURE);
   glPopMatrix();
   
   glDisable(GL_TEXTURE_2D);
   glMatrixMode(GL_MODELVIEW);
   glPopMatrix();

}

void renderScene() {

   static long delta = 0;
   long now = SDL_GetTicks();
   delta = now - dtime;
   dtime = now;

   static float t=0;
   
   glClear(GL_COLOR_BUFFER_BIT);
   glLoadIdentity();

   glTranslatef(0,0,-1000);

   if (!going_to_quit) {
   
      if (t < 300) {
         glColor3f(t*1.0f/300.0f,t*1.0f/300.0f,t*1.0f/300.0f);
      }
      else
         glColor3f(1,1,1);

   }
   
   do_background(t);

   if (t > 200) {
      if (t < 400)
         glTranslatef(-400+t,0,0);
      do_effect1(t);
   }

   if (t > 400)
      do_effect2(t);

   if (going_to_quit) {
      
      static float qt = 0;
      qt += 0.1f * (float)delta;

      if (qt < 250) {
         glColor3ub(1-(unsigned char)qt,1-(unsigned char)qt,1-(unsigned char)qt);
      }
      else
         APP_QUIT = true;
   
      t -= (0.1f -  0.02f) * (float) delta;
   
   }

   t += 0.1f * (float) delta;
   SDL_GL_SwapBuffers();
}


void keyPressed(SDLKey sym) {
   if (sym == SDLK_ESCAPE)
      going_to_quit = true;
}

void keyReleased(SDLKey sym) {
}

void initApp() {

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_COLOR_MATERIAL);
   glEnable(GL_NORMALIZE);
   glShadeModel(GL_FLAT);
   glEnable(GL_BLEND);
   glBlendFunc(GL_ONE,GL_ONE);
   glDisable(GL_DEPTH_TEST);
   
   loadTexture(&back_texid,"back.jpg");
   loadTexture(&particle_texid,"particle.jpg");
   loadTexture(&pred_texid,"particle_red.jpg");

   cube_list[0] = glGenLists(1);
   glNewList(cube_list[0],GL_COMPILE);
   drawCube(false);
   glEndList();
   
   cube_list[1] = glGenLists(1);
   glNewList(cube_list[1],GL_COMPILE);
   drawCube(false);
   glEndList();
   
   dtime = SDL_GetTicks();
}

void endApp() {
}
