/*
 * YILAN -- script versiyonu --  
 *
 *
 * Konu:
 *    Klasik oyunun OpenGL ile basit bir gerceklestirimi
 *    
 *
 * :: Deniz Aydinoglu    :: 2002 ::
 * :: www.oyunyapimi.org :: 2002 ::
 *
 */

#pragma warning(disable:4786)

#include "main.h"

int actor_x, actor_y, actor_xp;
map<string,Object> objTable;

bool  mup=false,mdown=false,mleft=false,mright=false;
long  dtime;
sTail tail[MAX_TAIL_LENGTH];
int   tailLen;
float pilex,piley;
float delay = 100.0f;

static lua_State *L = NULL;

/*
 * Bu yordam lua scriptleri icinden cagirilabiliyor.
 */
static int f_AddObject (lua_State *L) {
   AddObject(
      luaL_check_string(L, 1),
      luaL_check_number(L, 2),
      luaL_check_number(L, 3),
      luaL_check_number(L, 4),
      luaL_check_number(L, 5),
      luaL_check_number(L, 6)
   );
   return 1;
}

/*
 * Bu yordam lua scriptleri icinden cagirilabiliyor.
 */
static int f_RemoveObject (lua_State *L) {
   RemoveObject(
      luaL_check_string(L, 1)
   );
   return 1;
}

/*
 * Bu yordam lua scriptleri icinden cagirilabiliyor.
 */
static int f_IncreaseSpeed (lua_State *L) {
   IncreaseSpeed(
      luaL_check_number(L, 1)
   );
   return 1;
}

/*
 * lua yordam isimleri ile bizim yordamlarimiz arasinda baglanti
 * kurulmasina yardim eden yapi..
 */
static const struct luaL_reg mylib[] = {
   {"AddObject",     f_AddObject},
   {"RemoveObject",  f_RemoveObject},
   {"IncreaseSpeed", f_IncreaseSpeed}
};


/*
 * LUA sistemini baslatir, standart lua kutuphanelerini kullanima hazir
 * hale getirir, lua ile bizim yordamlarimiz arasindaki baglantiyi kurar.
 *
 */
void initLua() {

   L = lua_open(0);

   lua_baselibopen(L);
   lua_iolibopen(L);
   lua_strlibopen(L);
   lua_mathlibopen(L);
   lua_dblibopen(L);

   luaL_openl(L, mylib);
}

/*
 * Oyunumuza rengi verilen bir cisim ekler.
 */
void AddObject(const char *name,int x,int y,float r,float g,float b) {
   Object obj;
   obj.name = name;
   obj.x = x;
   obj.y = y;
   obj.colr = r;
   obj.colg = g;
   obj.colb = b;
   obj.visible = true;
   objTable[name] = obj;
}

/*
 * smi verilen cismi yok eder..
 */
void RemoveObject(const char *name) {
   objTable[name].visible = false;
}

/*
 * Yilanin hizini degistirir..
 */
void IncreaseSpeed(float incrFactor) {
   delay -= incrFactor;
}

/*
 * Bu yordam init.cpp deki SDL dongusunde devamli olarak cagiriliyor.
 * Icerisinde opengl cizim islemleri ve oyun mantigi geregi olan devamli
 * guncellemeler yapilabilir.
 *
 */

void renderScene() {

   // bu kisimda son yilan pozisyonunu degistirme isleminden
   // bu yana gecen sureyi hesapliyoruz (delta)
   static long delta = 0;
   long now = SDL_GetTicks();
   delta = now - dtime;
   
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glLoadIdentity();
   
   // Oyun alan fonunu ciz
   glBegin(GL_QUADS);
      glColor3f(0.9f,0.6f,0.2f); glVertex2f(0,0);
      glColor3f(0.5f,0.2f,0.3f); glVertex2f(0,400);
      glColor3f(0.5f,0.2f,0.3f); glVertex2f(400,400);
      glColor3f(0.9f,0.6f,0.2f); glVertex2f(400,0);
   glEnd();

   // yilani ciz
   glColor3f(0.2f,0.1f,0.9f);
   for (int i=0;i<tailLen;++i)
      glRectd(tail[i].x,tail[i].y,tail[i].x+10,tail[i].y+10);

   // yilan yemini ciz
   glColor3f(0.9f,0.9f,0);
   glRectd(pilex,piley,pilex+10,piley+10);

   // objeleri ciz..
   for (map<string,Object>::iterator oi=objTable.begin();oi!=objTable.end();++oi) {
      Object obj = oi->second;
      if (obj.visible) {
         glColor3f(obj.colr,obj.colg,obj.colb);
         glRectd(obj.x*10,obj.y*10,obj.x*10+10,obj.y*10+10);
      }
   }
  
   sTail &head = tail[0];
   
   // pozisyon degistirme icin gecmesi gereken sure dolmus ise...
   if (delta >= delay) {
   
      // her kuyruk parcasi onunde bulunan parcanin yerine geliyor..
      for (int i=tailLen-1;i>0;--i) {
         // hazir tum kuyruk icin donguye girmis iken, ayni zamanda kafanin kuyruga cerpmasi
         // kontrolunu de yapalim...
         if (head.x == tail[i].x && head.y == tail[i].y) {
            // carpisma olustu, yilan boyunu ve pozisyonunu baslangic durumuna getir
            Sleep(2000);
            head.x = 10;
            head.y = 10;
            tailLen = 2;
            delay = 100.0f;
            break;
         }
         tail[i] = tail[i-1];
      }

      // basilan tus durumuna gore yilanin on tarafinin pozisyonune degistir
      if (mup) head.y -= (10.0f);
      else
      if (mdown) head.y += (10.0f);
      else
      if (mleft) head.x -= (10.0f);
      else
      if (mright) head.x += (10.0f);

      // eger yilan yemi yiyor ise...
      if (head.x == pilex && head.y == piley) {
 
         // yeni yem kordinatlarini rastlantisal olarak belirle
         pilex = 10 * (rand()%40);
         piley = 10 * (rand()%40);

         // max yilan uzunluguna erisilmediyse uzunlugu bir arttir
         if (tailLen < MAX_TAIL_LENGTH) {
            tail[tailLen].x = -10;
            ++tailLen;
         }

         // bekleme suresini azalt. Bu sayede yilan daha kisa zamanda yeni
         // pozisyonuna gidecek, yani hizlanmaya baslayacak..
         delay -= 1.0f;

      }

      // oyun alani sinirlari ile carpismayi kontrol et..
      if (head.x >= 400 || head.x < 0 || head.y >= 400 || head.y < 0) {
         // carpisma olustu, yilan boyunu ve pozisyonunu baslangic durumuna getir
         Sleep(2000);
         head.x = 10;
         head.y = 10;
         tailLen = 2;
         delay = 100.0f;
      }

      // objeler ile carpismayi kontrol et..
      for (map<string,Object>::iterator oi=objTable.begin();oi!=objTable.end();++oi) {
         Object obj = oi->second;
         if (obj.visible) {
            if (head.x == obj.x*10 && head.y == obj.y*10) {
               // lua scriptimiz icerisindeki "OnCollision" isimli yordam cagiriliyor
               lua_getglobal(L,"OnCollision");
               lua_pushstring(L,obj.name.data());
               lua_call(L,1,0);
            }
         }
      }

      dtime = now;
      
   }
  
   SDL_GL_SwapBuffers();
}


/*
 * Bu yordam SDL tarafindan her tusa basilma durumunda cagirilir.
 * sym parametresi basilan tusun kodunu tasimaktadir.
 *
 */
void keyPressed(SDLKey sym) {

   // once tum diger yonlere gitme durumlarini sifirlayalim..
   mup = mdown = mleft = mright = false;
   
   // simdi ise basilan tusa gore bir yone dogru gidisi aktif hale getirelim..
   switch (sym) {

      case SDLK_UP:
         mup   = true;
         break;

      case SDLK_DOWN:
         mdown = true;
         break;

      case SDLK_LEFT:
         mleft  = true;
         break;

      case SDLK_RIGHT:
         mright = true;
         break;

   }

}

/*
 * Bu yordam SDL tarafindan tus birakilma durumunda cagirilir.
 * sym parametresi birakilan tusun kodunu tasimaktadir.
 *
 */
void keyReleased(SDLKey sym) {
}

/*
 * Programin basinda bir kez otomatik olarak cagirilan rutin.
 *
 */

void initApp() {

   // oyununumuz her ne kadar OpenGL kullansa da, aslinda 2 boyutlu bir ortamda geciyor..
   // OpenGL ile iki boyutlu bir calisma ortamini "ortographic projection" kullanarak
   // saglayabiliriz.. Bu yontem ile 3 boyutlu dunyaya cizilen sekiller pencere icine
   // goruntulenmek uzere yansitilirken persfektif dikkate alinmaz, dolayisi ile 2 boyutlu
   // bir goruntu olusur.. (3.boyut hissi alinmaz...)
   
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0,400,400,0,-1,1);
   glMatrixMode(GL_MODELVIEW);
   glDisable(GL_DEPTH_TEST);

   // rastlantisal sayi uretecini kuruyoruz..
   srand(time(NULL));
   
   // yilan ilk olarak saga gitsin
   mright = true;

   // 2 birim uzunlugunda bir yilan ile baslayalim.
   // hemen sonra yilanin kuyrugunun kordinatlarini belirtiyoruz..
   tailLen = 2;
   for (int i=0;i<tailLen;++i) {
      tail[i].x = -i*10;
      tail[i].y = 10;
   }

   // ilk rastgele yemin kordinatlarini belirle
   pilex = 10 * (rand()%40);
   piley = 10 * (rand()%40);

   // lua sistemini baslatiyoruz..
   initLua();

   // lua scriptimiz sisteme tanitiliyor..
   lua_dofile(L,"level1.lua");

   // lua scriptimiz icerisindeki "OnLevelStart" isimli yordam cagiriliyor
   lua_getglobal(L,"OnLevelStart");
   lua_call(L,0,0);

   // oyun baslangic zamani..
   dtime = SDL_GetTicks();
}

/*
 * Program biterken birkez cagirilan rutin..
 *
 */

void endApp() {
   lua_close(L);
}

